<?php

namespace TmdHelper\App\Api\Signon;

use TmdHelper\App\Interfaces\ApiInterface;
use WP_REST_Controller, WP_REST_Request, WP_Error, WP_REST_Server, WP_REST_Response;

/**
 * Class SignonApi
 */
class SignonApi extends WP_REST_Controller implements ApiInterface
{
    /**
     * @var
     */
    protected $signonManager;
    /**
     * @var \wpdb
     */
    private $wpdb;

    public function registerFields(){}

    /**
     * SettingsApi constructor.
     */
    public function __construct()
    {
        global $wpdb;
        $this->wpdb = $wpdb;
    }

    /**
     * Register the routes for the objects of the controller.
     */
    public function registerRoutes()
    {
        $version = '2';
        $namespace = 'wp/v' . $version;
        $base = 'redirect-to';
        register_rest_route(
            $namespace,
            '/' . $base,
            [
                [
                    'methods'             => WP_REST_Server::READABLE,
                    'callback'            => [$this, 'makeRedirect'],
                    'permission_callback' => [$this, 'get_items_permissions_check'],
                    'args'                => [
                        'key' => 'value',
                    ],
                ],
            ]
        );
        $base = 'save-key';
        register_rest_route(
            $namespace,
            '/' . $base,
            [
                [
                    'methods'             => WP_REST_Server::CREATABLE,
                    'callback'            => [$this, 'saveAuthKey'],
                    'permission_callback' => [$this, 'get_items_permissions_check'],
                    'args'                => [
                        'key' => 'value',
                    ],
                ],
            ]
        );
    }

    /**
     * @param $request
     */
    public function makeRedirect($request)
    {
        $queryParams = $request->get_query_params();
        $this->initSignonManager();
        $this->signonManager->doLoginAndRedirect($queryParams);
        exit;
    }

    /**
     * @param $request
     */
    public function saveAuthKey($request)
    {
        $bodyParams = $request->get_body_params();
        $this->initSignonManager();
        return $this->signonManager->saveAuthKey($bodyParams);
    }

    /**
     * @param WP_REST_Request $request Full data about the request.
     *
     * @return WP_Error|bool
     */
    public function get_items_permissions_check($request)
    {
        return true;
    }

    /**
     * Initializes $settingsManager
     */
    private function initSignonManager()
    {
        $this->signonManager = new SignonManager($this->wpdb);
    }
}