<?php

namespace TmdHelper\App\Api\Media;

use TmdHelper\App\Interfaces\ApiInterface;
use WP_REST_Controller, WP_REST_Request, WP_Error, WP_REST_Server, WP_REST_Response;

class MediaApi extends WP_REST_Controller implements ApiInterface
{
    const NAMESPACE = 'wp/v2';
    const BASE_ROUTE = '/media';

    /**
     * @var MediaManager
     */
    protected $mediaManager;

    /**
     * MediaApi constructor.
     */
    public function __construct()
    {
        $this->mediaManager = new MediaManager();
    }

    public function registerFields(){}

    public function registerRoutes()
    {
        // upload image
        register_rest_route(
            self::NAMESPACE,
            self::BASE_ROUTE . '/upload/image',
            [
                [
                    'methods' => WP_REST_Server::CREATABLE,
                    'callback' => [$this, 'uploadImageByUrl']
                ],
            ]
        );
    }

    public function uploadImageByUrl(WP_REST_Request $request)
    {
        try {
            $bodyParams = $request->get_body_params();
            $this->validateRequestParameters($bodyParams);
            $mediaInfo = $this->mediaManager->saveImageIntoMediaByUrl($bodyParams['imageUrl']);
        } catch (\Exception $exception) {
            return new WP_REST_Response([
                'status' => 'error',
                'message' => $exception->getMessage()
            ], 400);
        }

        return new WP_REST_Response([$mediaInfo], 200);
    }

    private function validateRequestParameters(array $bodyParams)
    {
        $errorMessage = null;
        if (!isset($bodyParams['imageUrl']) || empty($bodyParams['imageUrl'])) {
            $errorMessage = "Please specify a 'imageUrl' parameter";
        }
        if ($errorMessage) {
            throw new \Exception($errorMessage);
        }

        return true;
    }

}
