<?php
/**
 * Created by PhpStorm.
 * User: araqel
 * Date: 9/19/17
 * Time: 1:48 PM
 */

use Models\Tweaks\LoginDuration;

class TWS_Tweaks
{

    public static $instance;
    private $model;

    private function __construct()
    {

        $this->model = new LoginDuration();


        if ($this->check()) {
            $login_duration = $this->getLoginDuration();
            if ($login_duration) {
                add_filter('auth_cookie_expiration', function () use ($login_duration){
                    return $login_duration;
                }, 10);
            }
        }
    }

    private function check()
    {
        if ($this->model->checkStatus() == 'resolved') {
            return true;
        }

        return false;
    }

    private function getLoginDuration()
    {
        return $this->model->getLoginDuration();
    }

    public static function getInstance()
    {
        if (null == self::$instance) {
            self::$instance = new self;
        }

        return self::$instance;
    }

}