<?php

class TWS_Rest extends WP_REST_Controller
{
    private $version = '1';
    private $route = 'tws';
    private $status = 404;
    private $response = array();
    private $bases = array(
        'scan_data'    => array('route' => '/scan_data', 'methods' => WP_REST_Server::READABLE, 'args' => array()),
        'get_diff'     => array('route'   => '/get_diff',
                                'methods' => WP_REST_Server::CREATABLE,
                                'args'    => array(
                                    'file'        => array(
                                        'required' => true,
                                        'type'     => 'string',
                                    ),
                                    'file_status' => array(
                                        'required' => true,
                                        'type'     => 'string',
                                    ),
                                    'type'        => array(
                                        'required' => true,
                                        'type'     => 'int',
                                    )
                                )),
        'restore_file' => array('route'   => '/restore_file',
                                'methods' => WP_REST_Server::CREATABLE,
                                'args'    => array(
                                    'file'        => array(
                                        'required' => true,
                                        'type'     => 'string',
                                    ),
                                    'file_status' => array(
                                        'required' => true,
                                        'type'     => 'string',
                                    ),
                                    'type'        => array(
                                        'required' => true,
                                        'type'     => 'int',
                                    )
                                )),
        'delete_file'  => array('route'   => '/delete_file',
                                'methods' => WP_REST_Server::CREATABLE,
                                'args'    => array(
                                    'file'        => array(
                                        'required' => true,
                                        'type'     => 'string',
                                    ),
                                    'file_status' => array(
                                        'required' => true,
                                        'type'     => 'string',
                                    ),
                                )),
    );

    public function register_routes()
    {
        $namespace = $this->route . '/v' . $this->version;
        foreach ($this->bases as $base => $route_data) {
            register_rest_route($namespace, $route_data['route'], array(
                array(
                    'methods'  => $route_data['methods'],
                    'callback' => array($this, 'callback'),
                    'args'     => $route_data['args']
                )
            ));
        }
    }

    public function callback($request)
    {
        $route = $request->get_route();
        $parameters = wp_unslash($request->get_query_params());
        $endpoint = $this->parse_endpoint($route);
        $unauthorized = false;

        if (!defined('TENWEB_INCLUDES_DIR')) {
            $unauthorized = true;
        } else {
            include_once(TENWEB_INCLUDES_DIR . '/class-api.php');
            $token = $request->get_header('tenweb-authorization');
            $is_token_empty = empty($token);
            if ( $is_token_empty || \Tenweb_Manager\Api::get_instance()->check_single_token($token) === false) {
                $unauthorized = true;
            }
        }
        if ($unauthorized === true) {
            $data_for_response = array(
                "code"    => "unauthorized",
                "message" => "manager unauthorized, please login",
                "data"    => array(
                    "status" => 401
                )
            );

            return new \WP_REST_Response($data_for_response, 401);
        }


        switch ($endpoint) {
            case 'scan_data':
                $this->scan_data($request);
                break;

            case 'restore_file':
                $this->restore_file($request);
                break;
            case 'get_diff':
                $this->get_diff($request);
                break;
            case 'delete_file':
                $this->delete_file($request);
                break;

            default:
                $this->status = 404;
                $this->response = array(
                    "code"    => "rest_no_route",
                    "message" => "No route was found matching the URL and request method.",
                    "data"    => array(
                        "status" => 404
                    )
                );
                break;
        }

        return new \WP_REST_Response($this->response, $this->status);

    }

    public function scan_data(WP_REST_Request $request)
    {
        $scan = new \Controllers\ScannerController($request);
        $response = $scan->getScanData();
        $this->status = 200;
        $this->response = array('status' => 'ok', 'data' => $response);
    }

    public function restore_file(WP_REST_Request $request)
    {
        if ($request->get_param("type") == 'plugin' || $request->get_param("type") == 'theme') {
	        $slug = $request->get_param("slug");
	        $version = $request->get_param("version");
	        $is_slug_empty = empty($slug);
	        $is_version_empty = empty($version);
            if ($is_slug_empty || $is_version_empty ) {
                $this->status = 422;
                $this->response = array(
                    "code"    => "unprocessable_entity",
                    "message" => "Version and Slug fields are required.",
                    "data"    => array(
                        "status" => 422
                    )
                );

                return;
            }
        }
        $file = ABSPATH . '/' . $request->get_param('file');
        if (file_exists($file) === false && $request->get_param('file_status') != "missing_file") {
            $this->status = 500;
            $this->response = array(
                "code"    => "file_not_found",
                "message" => $request->get_param('file') . " file not found.",
                "data"    => array(
                    "status" => 500
                )
            );
        } else {
            $scan = new \Controllers\ScannerController($request);
            $response = $scan->restoreFileToOriginal();
            if ($response === true) {
                $this->status = 200;
                $this->response = array('status' => 'ok');
            } else {
                $this->status = 500;
                $this->response = array(
                    "code"    => "error",
                    "message" => "Something went wrong.",
                    "data"    => array(
                        "status" => 500
                    )
                );
            }
        }

    }


    public function get_diff(WP_REST_Request $request)
    {
        if ($request->get_param("type") == 'plugin' || $request->get_param("type") == 'theme') {
        	$slug = $request->get_param("slug");
        	$version = $request->get_param("version");
	        $is_slug_empty = empty($slug);
	        $is_version_empty = empty($version);
            if ($is_slug_empty || $is_version_empty) {
                $this->status = 422;
                $this->response = array(
                    "code"    => "unprocessable_entity",
                    "message" => "Version and Slug fields are required.",
                    "data"    => array(
                        "status" => 422
                    )
                );

                return;
            }
        }
        $file = ABSPATH . '/' . $request->get_param('file');
        if (file_exists($file) === false && $request->get_param('file_status') != "missing_file") {
            $this->status = 500;
            $this->response = array(
                "code"    => "file_not_found",
                "message" => $request->get_param('file') . " file not found.",
                "data"    => array(
                    "status" => 500
                )
            );
        } else {
            $scan = new \Controllers\ScannerController($request);
            $response = $scan->getDiff();
            $this->status = 200;
            $this->response = array('status' => 'ok', 'data' => $response);
        }
    }

    public function delete_file(WP_REST_Request $request)
    {
        $file = ABSPATH . '/' . $request->get_param('file');
        if (is_file($file) && $request->get_param('file_status') == "added_file") {
            if (unlink($file)) {
                $this->status = 200;
                $this->response = array('status' => 'ok');
            } else {
                $this->status = 500;
                $this->response = array(
                    "code"    => "can_not_delete_file",
                    "message" => "",
                    "data"    => array(
                        "status" => 500
                    )
                );
            }

        } else {
            $this->status = 500;
            $this->response = array(
                "code"    => "file_not_found",
                "message" => $request->get_param('file') . " file not found.",
                "data"    => array(
                    "status" => 500
                )
            );
        }
    }


    private function parse_endpoint($route)
    {
        $route_url = substr($route, 6);
        foreach ($this->bases as $key => $value) {
            $route_regex = '/' . substr($value['route'], 1) . '/';

            if (preg_match($route_regex, substr($route_url, 1))) {
                return $key;
            }
        }

        return null;
    }


}
