<?php

namespace Models\Tweaks;

use Models\Tweaks\Tweaks as Model;

class SecurityKeys extends Model
{
    public $action = 'security_keys';

    public function checkStatus()
    {
        if (in_array($this->action, $this->getWpOption(TWS_PREFIX . '_tweaks_ignored', array()))) {
            return 'ignored';
        }

        $security_keys = $this->getWpTransient(TWS_PREFIX . '_security_keys');

        if (!$security_keys) {
            return 'issues';
        } else {
            return 'resolved';
        }
    }

    public function fix()
    {

        /*
define('AUTH_KEY', ']x](sbnop](<L#a-ZKNWw$uqmyPA9?YXR;(6 1Dj04*l]u9w{!1FISDd+bxq@(dn');
define('SECURE_AUTH_KEY', 'ZF[JOZ$ebo2e>H6r.C0cLFZ3E;BOPs(XXVJ-]sme5zZ}Z<)+$o7jWpLgVmH#~L<*');
define('LOGGED_IN_KEY', 'G= /ETFg6r}RP7g5/ %liOw/7p8n%Tu^4a-Cr)hg|AHYKPmMDm%KU f|_mR.xd.K');
define('NONCE_KEY', 'hq%&Qe5uwImI0]ai4my0w{+B@PN3]``)c6L2Or<ty1a|=X!$e1hS(>&] H2M,3jm');
define('AUTH_SALT', 'lE#d`S:ZW1tm)tYS}`,%=d``8~)FX*am2zG`j6QI6NrrqK>|nG^hS;w+E<1iYK6Z');
define('SECURE_AUTH_SALT', '2M?h3Bk?3Y`{|G0yc_>6/,.?9 z8pafIrWrUoWv!H_a=q{UsrUc-/t$j_Rs{1y={');
define('LOGGED_IN_SALT', 'x+ZSX[YN>g(t{j]usy4vMWhK__&#;1rp_{#Ftp`Yz_?y2dzw/JN~x}*[a-^})rC^');
define('NONCE_SALT', 'AB|k>Y7tOc(e(O7bW Rf=F/sJ~Oi0su}T_bnl&A_y6p#EkupF ;<IUm@Rf*xU6H$');
*/

        $conf_path = $this->getWpConfigPath();
        $conf_file = file($conf_path);
        $keys = array(
            'AUTH_KEY',
            'SECURE_AUTH_KEY',
            'LOGGED_IN_KEY',
            'NONCE_KEY',
            'AUTH_SALT',
            'SECURE_AUTH_SALT',
            'LOGGED_IN_SALT',
            'NONCE_SALT',
        );

        foreach ($keys as $key) {

            if (!defined($key)) {
                return false;
            }
        }

        foreach ($keys as $key) {
            $conf_line = $this->findConfig($conf_file, $key);
            if (!$conf_line) {
                return false;
            }
            $new_key = wp_generate_password(64, true, true);

            $conf_file[$conf_line] = "define( '$key', '$new_key' );" . PHP_EOL;

        }

        $conf_str = implode('', $conf_file);

        if (!file_put_contents($conf_path, $conf_str)) {
            return false;
        }

        $expiration = 60 * DAY_IN_SECONDS;

        if (isset($_POST['tws_remind_keys']) && $_POST['tws_remind_keys'] != '') {
            $expiration = $_POST['tws_remind_keys'];
        }

        $this->setWpTransient(TWS_PREFIX . '_security_keys', 1, $expiration);

        return true;

    }

    public function revert()
    {
        /*$this->setWpOption('default_pingback_flag', 1);
        $this->setWpOption('default_ping_status', 'open');*/

    }


    public function findConfig($config, $option)
    {
        $needle = "(^define\(\s*['|\"]" . $option . "['|\"]\s*,(.*)\))";

        foreach ($config as $line_num => $line) {
            if (preg_match($needle, $line, $matches)) {
                return $line_num;
            }
        }

        return false;
    }
}