<?php

namespace Models\Tweaks;

use Models\Tweaks\Tweaks as Model;

class PreventPhpExecution extends Model {
	public $action = 'prevent_information_disclosure';

	private $wpinclude_rules = array(
	);

	private $wpcontent_rules = array(
	);

	private $htaccess_wpinclude_path = null;
	private $htaccess_wpcontent_path = null;

	public static $excluded_variable = null;

    public function __construct(){
        $this->wpinclude_rules = array(
            PHP_EOL . '######### Added by 10Web Security plugin #########' . PHP_EOL,

            '<Files *.php>' . PHP_EOL .
            'Order allow,deny' . PHP_EOL .
            'Deny from all' . PHP_EOL .
            '</Files>' . PHP_EOL,
            '<Files wp-tinymce.php>' . PHP_EOL .
            'Allow from all' . PHP_EOL .
            '</Files>' . PHP_EOL,
            '<Files ms-files.php>' . PHP_EOL .
            'Allow from all' . PHP_EOL .
            '</Files>' . PHP_EOL,

            '######### 10Web Security plugin tweak end #########' . PHP_EOL
        );

        $this->wpcontent_rules = array(
            PHP_EOL . '######### Added by 10Web Security plugin #########' . PHP_EOL,

            '<Files *.php>' . PHP_EOL .
            'Order allow,deny' . PHP_EOL .
            'Deny from all' . PHP_EOL .
            '</Files>' . PHP_EOL,

            '######### 10Web Security plugin tweak end #########' . PHP_EOL
        );

        $this->htaccess_wpinclude_path = ABSPATH . WPINC . '/' . '.htaccess';
        $this->htaccess_wpcontent_path = WP_CONTENT_DIR . '/' . '.htaccess';

        self::$excluded_variable = TWS_PREFIX.'_executable_files';
    }
	public function checkStatus() {
		if ( in_array( $this->action, $this->getWpOption( TWS_PREFIX . '_tweaks_ignored', array() ) ) ) {
			return 'ignored';
		}

		$this->checkFileExistence();

		$upload_dir = $this->getUploadDirUrl();
		$url        = $upload_dir . '/tenweb-security/index.php';
		$status     = wp_remote_head( $url, array( 'user-agent' => $_SERVER['HTTP_USER_AGENT'] ) );
		if ( is_wp_error( $status ) ) {
			return 'resolved';
		} else {
			if ( 200 == wp_remote_retrieve_response_code( $status ) ) {
				return 'issues';
			}

			return 'resolved';
		}
	}

	private function checkFileExistence() {
		$upload_dir = $this->getUploadDir();


		$tenweb_dir = $upload_dir . DIRECTORY_SEPARATOR . 'tenweb-security';
		if ( ! is_dir( $tenweb_dir ) ) {
			wp_mkdir_p( $tenweb_dir );
		}

		if ( ! is_file( $tenweb_dir . DIRECTORY_SEPARATOR . 'index.php' ) ) {
			//create a blank index file
			file_put_contents( $tenweb_dir . DIRECTORY_SEPARATOR . 'index.php', '' );
		}
	}

	private function getUploadDir() {
		$upload_dir = wp_upload_dir();

		return $upload_dir['basedir'];
	}

	private function getUploadDirUrl() {
		$upload_dir = wp_upload_dir();

		return $upload_dir['baseurl'];
	}

	public function fix() {

		if ( ! $this->fixWpInclude() ) {
			return false;
		}

		if ( ! $this->fixWpContent() ) {
			return false;
		}


		return true;

	}

	private function fixWpInclude() {
		$htaccess_path = $this->htaccess_wpinclude_path;
		//todo add return error of non writable file
		if ( ! is_file( $htaccess_path ) ) {
			if ( ! file_put_contents( $htaccess_path, '', LOCK_EX ) ) {
				return false;
			}
		} else if ( ! is_writeable( $htaccess_path ) ) {
			return false;
		}

		$htaccess_config   = file( $htaccess_path );
		$rules             = $this->wpinclude_rules;
		$rules_in_htaccess = array_diff( $rules, $htaccess_config );
		if ( count( $rules_in_htaccess ) == 0 || ( count( $rules_in_htaccess ) == count( $rules ) ) ) {
			$htaccess_config = array_merge( $htaccess_config, array( implode( '', $rules ) ) );
			$result          = file_put_contents( $htaccess_path, implode( '', $htaccess_config ), LOCK_EX );
		}

		return true;
	}

	private function fixWpContent() {
		$htaccess_path = $this->htaccess_wpcontent_path;
		//todo add return error of non writable file
		if ( ! is_file( $htaccess_path ) ) {
			if ( ! file_put_contents( $htaccess_path, '', LOCK_EX ) ) {
				return false;
			}
		} else if ( ! is_writeable( $htaccess_path ) ) {
			return false;
		}

		$htaccess_config   = file( $htaccess_path );
		$rules             = $this->wpcontent_rules;
		$is_empty_excluded = empty( $_POST['excluded']);
		if ( ! $is_empty_excluded ) {

			$this->setWpOption(self::$excluded_variable,$_POST['excluded'] );
			$paths = explode( "\n", $_POST['excluded'] );
			$custom_exclude = array();

			foreach ( $paths as $file_path ) {
				$file_path = trim( preg_replace('/\s\s+/', ' ', $file_path ) );
				$is_empty_filepath = empty( $file_path ) ;
				if ( !$is_empty_filepath ) {
					$custom_exclude[] = '<Files ' . $file_path . '> '. PHP_EOL .
					                    'Allow from all' . PHP_EOL .
					                    '</Files>' . PHP_EOL;
				}
			}

			$is_empty_custom_exclude = empty( $custom_exclude ) ;
			if ( !$is_empty_custom_exclude ) {
				array_splice( $rules, 2, 0, $custom_exclude );
				//todo add rules to db

			}

		}
		$rules_in_htaccess = array_diff( $rules, $htaccess_config );
		if ( count( $rules_in_htaccess ) == 0 || ( count( $rules_in_htaccess ) == count( $rules ) ) ) {
			$htaccess_config = array_merge( $htaccess_config, array( implode( '', $rules ) ) );
			$result          = file_put_contents( $htaccess_path, implode( '', $htaccess_config ), LOCK_EX );
		}

		return true;
	}

	public function revert() {
		global $is_apache;
		echo 'ffffffffffffffffffff';

		if ( $is_apache ) {
			echo 'sssssssssssssssssss';

			if ( ! $this->revertWpInclude()) {
				echo 'AAAAAAAAAAA';
				return false;
			}

			if ( ! $this->revertWpContent() ) {
				echo 'BBBBBBBBBBBBBBB';
				return false;
			}

			return true;
		} else {
			echo 'ffffffffffhjjjjjjjjjjjjjjffffffffff';

			//no revert
			return false;
		}
	}

	private function revertWpInclude() {
		$htaccess_path = $this->htaccess_wpinclude_path;

		if ( ! is_writeable( $htaccess_path ) ) {
			//todo add return error of non writable file
			return false;
		}
		$htaccess_config = file_get_contents( $htaccess_path );
		$rules           = $this->wpinclude_rules;
		$rules           = implode( '', $rules );
		$htaccess_config = str_replace( $rules, '', $htaccess_config );
		$htaccess_config = trim( $htaccess_config );
		file_put_contents( $htaccess_path, $htaccess_config, LOCK_EX );

		return true;
	}

	private function revertWpContent() {
		$htaccess_path = $this->htaccess_wpcontent_path;

		if ( ! is_writeable( $htaccess_path ) ) {
			//todo add return error of non writable file
			return false;
		}
		$htaccess_config = file_get_contents( $htaccess_path );
		$rules             = $this->wpcontent_rules;
		$data = $this->getWpOption(self::$excluded_variable, '');
		$is_empty_data = empty( $data );
		if ( ! $is_empty_data ) {

			$paths = explode( "\n", $data);
			$custom_exclude = array();

			foreach ( $paths as $file_path ) {
				$file_path = trim( preg_replace('/\s\s+/', ' ', $file_path ) );
				$is_empty_file_path = empty( $file_path );
				if ( ! $is_empty_file_path) {
					$custom_exclude[] = '<Files ' . $file_path . '> '. PHP_EOL .
					                    'Allow from all' . PHP_EOL .
					                    '</Files>' . PHP_EOL;
				}
			}
			$is_empty_custom_exclude = empty( $custom_exclude );
			if ( ! $is_empty_custom_exclude ) {
				array_splice( $rules, 2, 0, $custom_exclude );
			}
			$this->setWpOption(self::$excluded_variable, '');
		}
		$rules           = implode( '', $rules );
		$htaccess_config = str_replace( $rules, '', $htaccess_config );
		$htaccess_config = trim( $htaccess_config );
		file_put_contents( $htaccess_path, $htaccess_config, LOCK_EX );


		return true;
	}



}