<?php

namespace Models\Tweaks;

use Helpers\Notifications;
use Models\Tweaks\Tweaks as Model;

class PreventInformationDisclosure extends Model {


	public $action = 'prevent_information_disclosure';

	private $rules = array();

	private $htaccess_path = null;

	public function __construct(){
        $this->htaccess_path = ABSPATH . '.htaccess';
        $this->rules = array(
            PHP_EOL . '######### Added by 10Web Security plugin #########' . PHP_EOL,

            '<FilesMatch "\.(txt|md|exe|sh|bak|inc|pot|po|mo|log|sql)$">' . PHP_EOL .
            'Order allow,deny' . PHP_EOL .
            'Deny from all' . PHP_EOL .
            '</FilesMatch>' . PHP_EOL,

            '<Files robots.txt>' . PHP_EOL .
            'Allow from all' . PHP_EOL .
            '</Files>' . PHP_EOL,

            '<Files wp-config.php>' . PHP_EOL .
            'order allow,deny' . PHP_EOL .
            'deny from all' . PHP_EOL .
            '</Files>' . PHP_EOL,

            '<Files ~ "^.*\.([Hh][Tt][Aa])">' . PHP_EOL .
            'Order allow,deny' . PHP_EOL .
            'Deny from all' . PHP_EOL .
            'Satisfy all' . PHP_EOL .
            '</Files>' . PHP_EOL,

            '######### 10Web Security plugin tweak end #########' . PHP_EOL
        );
    }

	public function checkStatus() {
		if ( in_array( $this->action, $this->getWpOption( TWS_PREFIX . '_tweaks_ignored', array() ) ) ) {
			return 'ignored';
		}

		$url    = TWS_URL . '/readme.txt';
		$status = wp_remote_head( $url, array( 'user-agent' => $_SERVER['HTTP_USER_AGENT'] ) );
		if ( 200 == wp_remote_retrieve_response_code( $status ) ) {
			return 'issues';
		} else {
			return 'resolved';
		}
	}

	public function fix() {

		$notifs = new Notifications();
		$htaccess_path = $this->htaccess_path;
		if ( ! is_file( $htaccess_path ) ) {
			file_put_contents( $htaccess_path, '', LOCK_EX );
		}
		if ( ! is_writeable( $htaccess_path ) ) {
			//todo add return error of non writable file
			return false;
		}
		$htaccess_config = file( $htaccess_path );
		$rules           = $this->rules;
		//var_dump( $rules );
		$rules_in_htaccess = array_diff( $rules, $htaccess_config );
		if ( count( $rules_in_htaccess ) == 0 || ( count( $rules_in_htaccess ) == count( $rules ) ) ) {
			$htaccess_config = array_merge( $htaccess_config, array( implode( '', $rules ) ) );
			$result = file_put_contents( $htaccess_path, implode( '', $htaccess_config ), LOCK_EX );
			if (!$result) {
				$notifs->setNotif('Can not pach .htaccess');
			}
		}

		return true;

	}

	public function revert() {
		global $is_apache;
		$notifs = new Notifications();

		if ( $is_apache ) {
			$htaccess_path = $this->htaccess_path;

			if ( ! is_writeable( $htaccess_path ) ) {
				//todo add return error of non writable file
				return false;
			}
			$htaccess_config = file_get_contents( $htaccess_path );
			$rules           = $this->rules;
			$rules           = implode( '', $rules );
			$htaccess_config = str_replace( $rules, '', $htaccess_config );
			$htaccess_config = trim( $htaccess_config );
			$result = file_put_contents( $htaccess_path, $htaccess_config, LOCK_EX );
			if (!$result) {
				$notifs->setNotif('Can not pach .htaccess');
			}
			return true;
		} else {
			//no revert
			return false;
		}
	}

}