<?php

namespace Models\Tweaks;

use Models\Tweaks\Tweaks as Model;

class PhpVersion extends Model
{
    public $action = 'disable_editor';


    public function checkStatus()
    {
        if (in_array($this->action, $this->getWpOption(TWS_PREFIX . '_tweaks_ignored', array()))) {
            return 'ignored';
        }
        $version = phpversion();

        if (version_compare($version, '5.6', '<') === false) {
            return 'resolved';
        } else {
            return 'issues';
        }
    }
}