<?php

namespace Models\Tweaks;

use Models\Tweaks\Tweaks as Model;

class LoginDuration extends Model
{
    public $action = 'login_duration';

    public function checkStatus()
    {
        if (in_array($this->action, $this->getWpOption(TWS_PREFIX . '_tweaks_ignored', array()))) {
            return 'ignored';
        }

        $login_duration = $this->getWpOption('tws_login_duration');

        if (!$login_duration) {
            return 'issues';
        } else {
            return 'resolved';
        }
    }

    public function fix()
    {
        $login_duration = 1;
        if (isset($_POST['tws_login_duration']) && $_POST['tws_login_duration'] != 0) {
            $login_duration = $_POST['tws_login_duration'];
        }
        $this->setWpOption('tws_login_duration', $login_duration);
    }

    public function revert()
    {
        if (!$this->deleteWpOption('tws_login_duration')) {
            return false;
        }
    }

    public function getLoginDuration()
    {
        $login_duration = $this->getWpOption('tws_login_duration');
        if (!$login_duration) {
            return false;
        }

        return (int)$login_duration * 86400;
    }
}