<?php

namespace Models\Tweaks;

use Models\Tweaks\Tweaks as Model;

class ErrorReporting extends Model
{
    public $action = 'error_reporting';

    public function checkStatus()
    {
        if (in_array($this->action, $this->getWpOption(TWS_PREFIX . '_tweaks_ignored', array()))) {
            return 'ignored';
        }
        $conf_path = $this->getWpConfigPath();
        $conf_file = file($conf_path);
        $conf_match = $this->findConfig($conf_file);

        if (!$conf_match || $conf_match['value'] == 'true') {
            return 'issues';
        } else {
            return 'resolved';
        }
    }

    public function fix()
    {
        $conf_path = $this->getWpConfigPath();
        $conf_file = file($conf_path);
        $conf_match = $this->findConfig($conf_file);
        if (!$conf_match) {
            $insert_line = $this->getWpConfigInsertLine($conf_file) + 1;
            $new_line = "define( 'WP_DEBUG',false);" . PHP_EOL;
            array_splice($conf_file, $insert_line, 0, $new_line);
        } else {
            $line_num = $conf_match['line_num'];
            $conf_file[$line_num] = "define( 'WP_DEBUG',false);" . PHP_EOL;
        }


        $conf_str = implode(null, $conf_file);

        file_put_contents($conf_path, $conf_str);

    }

    public function revert()
    {
        $conf_path = $this->getWpConfigPath();
        $conf_file = file($conf_path);
        $conf_match = $this->findConfig($conf_file);

        if (!$conf_match || $conf_match['value'] == 'true') {
            return false;
        }
        $line_num = $conf_match['line_num'];

        $conf_file[$line_num] = "define( 'WP_DEBUG',true);" . PHP_EOL;

        $conf_str = implode('', $conf_file);
        file_put_contents($conf_path, $conf_str);
    }

    public function findConfig($config)
    {
        $needle = "(^define\(\s*['|\"]WP_DEBUG['|\"]\s*,(.*)\))";

        foreach ($config as $line_num => $line) {
            if (preg_match($needle, $line, $matches)) {
                return array('line_num' => $line_num, 'value' => trim($matches[1]));
            }
        }

        return false;
    }
}