<?php

namespace Models\Tweaks;

use Models\Tweaks\Tweaks as Model;

class DisableTrackbacks extends Model
{
    public $action = 'disable_trackbacks';

    public function checkStatus()
    {
        if (in_array($this->action, $this->getWpOption(TWS_PREFIX . '_tweaks_ignored', array()))) {
            return 'ignored';
        }

        $ping_back = $this->getWpOption('default_pingback_flag');
        $ping_status = $this->getWpOption('default_ping_status');
        if ($ping_back || $ping_status == 'open') {
            return 'issues';
        } else {
            return 'resolved';
        }
    }

    public function fix()
    {
        $this->setWpOption('default_pingback_flag', '');
        $this->setWpOption('default_ping_status', 'closed');
    }

    public function revert()
    {
        $this->setWpOption('default_pingback_flag', 1);
        $this->setWpOption('default_ping_status', 'open');

    }

}