<?php

namespace Models\Tweaks;

use Models\Tweaks\Tweaks as Model;

class DisableEditor extends Model
{

    public $action = 'disable_editor';

    public function checkStatus()
    {
        if (in_array($this->action, $this->getWpOption(TWS_PREFIX . '_tweaks_ignored', array()))) {
            return 'ignored';
        }

        $conf_path = $this->getWpConfigPath();
        $conf_file = file($conf_path);
        if (!$this->findConfig($conf_file)) {
            return 'issues';
        } else {
            return 'resolved';
        }
    }

    public function fix()
    {
        $conf_path = $this->getWpConfigPath();
        $conf_file = file($conf_path);
        $insert_line = $this->getWpConfigInsertLine($conf_file) + 1;
        $new_line = "define( 'DISALLOW_FILE_EDIT',true);" . PHP_EOL;

        array_splice($conf_file, $insert_line, 0, $new_line);

        $conf_str = implode(null, $conf_file);

        file_put_contents($conf_path, $conf_str);

    }

    public function revert()
    {
        $conf_path = $this->getWpConfigPath();
        $conf_file = file($conf_path);
        $conf_match = $this->findConfig($conf_file);
        if (!$conf_match) {
            return false;
        }
        $line_num = $conf_match['line_num'];

        unset($conf_file[$line_num]);

        $conf_str = implode('', $conf_file);
        file_put_contents($conf_path, $conf_str);

    }


    public function findConfig($config)
    {
        $needle = "(^define\(\s*['|\"]DISALLOW_FILE_EDIT['|\"]\s*,(.*)\))";

        foreach ($config as $line_num => $line) {
            if (preg_match($needle, $line, $matches)) {
                return array('line_num' => $line_num, 'line' => $matches[0]);
            }
        }

        return false;
    }
}