<?php

namespace Models\Tweaks;

use Models\Tweaks\Tweaks as Model;
use WP_Error;

class ChangePrefix extends Model
{
    public $action = 'change_prefix';

    public function checkStatus()
    {
        if (in_array($this->action, $this->getWpOption(TWS_PREFIX . '_tweaks_ignored', array()))) {
            return 'ignored';
        }

        global $wpdb;
        //TODO change test_ to wp_
        if ($wpdb->prefix == 'wp_') {
            return 'issues';
        } else {
            return 'resolved';
        }
    }

    public function fix()
    {
        global $wpdb;
        $old_prefix = $wpdb->prefix;

        if (isset($_POST['tws_db_prefix']) && $_POST['tws_db_prefix'] != '') {
            $prefix = $_POST['tws_db_prefix'] . '_';
        } else {
            return false;
        }

        $wpdb->query('SET autocommit=0');
        $wpdb->query('BEGIN');

        $this->renameTables($old_prefix, $prefix);


        if (!$this->changeDB($old_prefix, $prefix)) {
            $wpdb->query('ROLLBACK');
            $this->renameTables($prefix, $old_prefix);

            return false;
        }

        if (!$this->changeConfFile($prefix)) {
            $wpdb->query('ROLLBACK');
            $this->renameTables($prefix, $old_prefix);

            return false;
        }

        $wpdb->query('COMMIT');

    }

    public function revert()
    {
        global $wpdb;

        $old_prefix = $wpdb->prefix;
        $prefix = 'wp_';

        $wpdb->query('SET autocommit=0');
        $wpdb->query('BEGIN');

        $this->renameTables($old_prefix, $prefix);

        if (!$this->changeDB($old_prefix, $prefix)) {
            $wpdb->query('ROLLBACK');
            $this->renameTables($prefix, $old_prefix);

            return false;
        }


        if (!$this->changeConfFile($prefix)) {
            $wpdb->query('ROLLBACK');
            $this->renameTables($prefix, $old_prefix);

            return false;
        }

        $wpdb->query('COMMIT');
    }

    public function changeConfFile($prefix)
    {

        $conf_path = $this->getWpConfigPath();
        if (!$conf_path) {
            return false;
        }

        $conf_file = file($conf_path);
        $conf_line_num = $this->findConfig($conf_file);

        if (!$conf_line_num) {
            return false;
        }

        $new_line = "\$table_prefix = '" . $prefix . "';" . PHP_EOL;
        $conf_file[$conf_line_num] = $new_line;

        $conf_str = implode(null, $conf_file);
        if (!file_put_contents($conf_path, $conf_str)) {
            return false;
        }

        return true;
    }

    public function renameTables($old_prefix, $new_prefix)
    {
        global $wpdb;
        $tables = $wpdb->get_col($wpdb->prepare('SHOW TABLES LIKE %s', $wpdb->esc_like($old_prefix ). '%'));
        $rename_tables = array();
        foreach ($tables as $table) {
            $new_name = substr($table, strlen($old_prefix));
            $rename_tables[] = '`' . $table . '`' . ' to ' . '`' . $new_prefix . $new_name . '`';
        }

        $query = 'RENAME TABLE ' . implode(',', $rename_tables);

        if ($wpdb->query($query) === false) {
            return false;
        }

    }

    public function changeDB($old_prefix, $new_prefix)
    {
        global $wpdb;
        $wpdb->show_errors;

        $query = "UPDATE `" . $new_prefix . "usermeta` 
        SET `meta_key`=
        CONCAT('%s',
        RIGHT(`meta_key`,CHAR_LENGTH(`meta_key`)-%d)) 
        WHERE `meta_key` LIKE %s";

        if ($wpdb->query($wpdb->prepare($query, $new_prefix,
                strlen($old_prefix), $old_prefix . '%')) === false) {
            return false;
        }


        $query = "UPDATE `" . $new_prefix . "options` SET option_name=%s WHERE option_name=%s";

        if ($wpdb->query($wpdb->prepare($query, $new_prefix . 'user_roles',
                $old_prefix . 'user_roles')) === false) {
            return false;
        }


        return true;
    }

    public function findConfig($config)
    {
        global $wpdb;
        $needle = '(^\$table_prefix\s*=\s*[\'|\"]' . $wpdb->prefix . '[\'|\"])';

        foreach ($config as $line_num => $line) {
            if (preg_match($needle, $line, $matches)) {
                return $line_num;
            }
        }

        return false;
    }
}