<?php

namespace Models\Tweaks;

use Models\Tweaks\Tweaks as Model;

class ChangeDefaultUserAccount extends Model
{

    public $action = 'change_default_user';

    public function checkStatus()
    {
        if (in_array($this->action, $this->getWpOption(TWS_PREFIX . '_tweaks_ignored', array()))) {
            return 'ignored';
        }

        $user = get_user_by('login', 'admin');
		$is_empty_user = empty($user);
        if (!$is_empty_user) {
            return 'issues';
        } else {
            return 'resolved';
        }
    }

    public function fix()
    {
        global $wpdb;

        $user = get_user_by('login', 'admin');
	    $is_empty_user = empty($user);
        if ($is_empty_user) {
            return false;
        }

        $wpdb->update($wpdb->users, array('user_login' => trim($_POST['tws_username'])), array('ID' => $user->ID));

        return true;
    }
}