<?php
/**
 * Created by PhpStorm.
 * User: anna
 * Date: 9/13/17
 * Time: 6:54 PM
 */

namespace Models\Lockouts;

use Models\Lockouts\Lockouts as Model;

class Logs extends Model
{
    public $attempts = null;
    public $date;
    public $type;
    public $status = "active";
    public $username = "";
    private $table;
    private $db;
    private $date_filter;
    private $status_filter;
    private $limit;

    public function __construct($ip = null, $date_filter = null, $status_filter = null, $type = null, $limit = null)
    {
        global $wpdb;
        parent::__construct($ip);
        $this->db = $wpdb;
        $this->table = $wpdb->prefix . TWS_PREFIX . "_logs";
        $this->date_filter = isset($_POST["date"]) ? $_POST["date"] : $date_filter;
        $this->status_filter = isset($_POST["status"]) ? $_POST["status"] : $status_filter;
        $this->type = isset($_POST["type"]) ? $_POST["type"] : $type;
        $this->limit = isset($_POST["limit"]) ? $_POST["limit"] : $limit;
    }

    public function getLogs()
    {
        $where = $this->getFilters();
        $limit = isset($this->limit) ? ("LIMIT 0," . $this->limit) : "";
        $logs = $this->db->get_results("SELECT * FROM " . $this->table . $where . " ORDER BY id DESC " . $limit);

        return $logs;
    }

    public function getLogsTotal()
    {
        $where = $this->getFilters();
        $total = $this->db->get_var("SELECT COUNT(*) FROM " . $this->table . $where);

        return $total;
    }

    public function getFilters()
    {
        // filter data
        $filter_data = array();
        if (isset($this->date_filter) && $this->date_filter) {
            $filter_data[] = "DATE_ADD(`date`, INTERVAL " . $this->date_filter . ") >= NOW()";
        }
        if (isset($this->status_filter) && $this->status_filter != "") {
            $filter_data[] = "`status`='" . $this->status_filter . "'";
        }
        if (isset($this->type) && $this->type != "") {
            $filter_data[] = "`type`='" . $this->type . "'";
        }

        $where = count($filter_data) > 0 ? " WHERE " . implode(" AND ", $filter_data) : "";

        return $where;
    }


    public function addLog($status = "active")
    {
        $data = array(
            "ip"       => $this->ip,
            "attempts" => 1,
            "username" => $this->username,
            "date"     => date("Y-m-d H:i:s"),
            "type"     => $this->type,
            "status"   => $status,
        );
        $format = array("%s", "%d", "%s", "%s");

        $this->db->insert($this->table, $data, $format);
    }

    public function updateLog($id, $status, $attempts = null, $username = "")
    {
        $data = array(
            "status" => $status,
        );
        $format = array("%s");

        if ($attempts) {
            $data["attempts"] = $attempts;
            $format[] = "%d";
        }
        if ($username) {
            $data["username"] = $username;
            $format[] = "%s";
        }
        $where_data = array("id" => $id);
        $where_format = array("%d");

        $this->db->update($this->table, $data, $where_data, $format, $where_format);
    }

    public function getLogByIp()
    {
        $log = $this->db->get_row($this->db->prepare("SELECT * FROM " . $this->table . " WHERE `ip` = %s  AND `status` = %s AND `type` = %s", $this->ip, "active", $this->type));

        return $log;
    }

    public function getLastLockout()
    {
        $last_lockout = $this->db->get_var("SELECT CONCAT(MAX(date), ' - ',  ip)FROM " . $this->table . " WHERE `status` = 'locked'");

        return $last_lockout;
    }

    public function renderHtml()
    {
        $lockouts = $this->getLogs();
        $html = '';
        $is_empty_lockouts = empty($lockouts);
        if (!$is_empty_lockouts) {
            $html = '<table cellpadding="5" cellspacing="5">';
            foreach ($lockouts as $lockout) {
                $html .= '<tr><td style="border: 1px solid #969492;
    border-collapse: collapse;">' . $lockout->date . '</td><td style="border: 1px solid #969492;
    border-collapse: collapse;">' . $lockout->ip . '</td></tr>';
            }
            $html .= '</table>';
        }

        return $html;
    }

}