<?php

namespace Models\Lockouts;

use Models\Lockouts\Lockouts as Model;

class LoginProtection extends Model
{
    public $enable_login_protection = 0;
    public $threshold_attempts = 5;
    public $threshold_time_period = 300;
    public $lockout_time = 300;
    public $lockout_message = "You have been locked out due to too many invalid login attempts.";
    public $ban_usernames = array();

    public function __construct($ip = null)
    {
        parent::__construct($ip);
        $this->enable_login_protection = $this->options["enable_login_protection"];
        $this->threshold_attempts = $this->options["threshold_login_attempts"];
        $this->threshold_time_period = $this->options["threshold_login_time_period"];
        $this->lockout_time = $this->options["login_lockout_time"];
        $this->lockout_message = $this->options["login_lockout_message"];
        $this->ban_usernames = (array)$this->options["ban_usernames"];
    }


    public static function getSettings()
    {
        return array(
            "enable_login_protection" => array(
                "type"      => "radio",
                "choices"   => array(
                    0 => array(
                        "label"   => __("No", TWS_PREFIX),
                        "value"   => 0,
                        "classes" => "",
                        "attr"    => "",
                    ),
                    1 => array(
                        "label"   => __("Yes", TWS_PREFIX),
                        "value"   => 1,
                        "classes" => "",
                        "attr"    => "",
                    ),

                ),
                "label"     => __("Enable login protection", TWS_PREFIX),
                "help_text" => "",
                "tooltip"   => __("Enable login protection.", TWS_PREFIX),
            ),

            "threshold_login_attempts" => array(
                "type"      => "text",
                "label"     => __("How many failed login attempts will trigger a lockout", TWS_PREFIX),
                "classes"   => "tws-elem-250",
                "attr"      => "",
                "help_text" => "",
                "tooltip"   => __("How many failed login attempts will trigger a lockout", TWS_PREFIX),
            ),

            "threshold_login_time_period" => array(
                "type"      => "text",
                "label"     => __("What time period for failed login attempts will trigger a lockout", TWS_PREFIX),
                "classes"   => "tws-elem-250",
                "attr"      => "",
                "help_text" => __("seconds", TWS_PREFIX),
                "tooltip"   => __("What time period for failed login attempts will trigger a lockout", TWS_PREFIX),
            ),
            "login_lockout_time"          => array(
                "type"      => "text",
                "label"     => __("Lockout time", TWS_PREFIX),
                "classes"   => "tws-elem-250",
                "attr"      => "",
                "help_text" => __("seconds", TWS_PREFIX),
                "tooltip"   => __("Lockout time", TWS_PREFIX),
            ),
            "login_lockout_message"       => array(
                "type"      => "textarea",
                "label"     => __("Lockout message", TWS_PREFIX),
                "classes"   => "tws-elem-450",
                "attr"      => "rows=4",
                "help_text" => "",
                "tooltip"   => __("Lockout message", TWS_PREFIX),
            ),
            "ban_usernames"               => array(
                "type"      => "textarea",
                "label"     => __("Automatically ban usernames", TWS_PREFIX),
                "classes"   => "tws-elem-450",
                "attr"      => "rows=8",
                "help_text" => "",
                "tooltip"   => __("Automatically ban usernames", TWS_PREFIX),
            ),
        );
    }




}