<?php
/**
 * Created by PhpStorm.
 * User: anna
 * Date: 9/13/17
 * Time: 5:56 PM
 */

namespace Models\Lockouts;


use Models\BaseModel;

class Lockouts extends BaseModel
{
    public $options = array();
    public $tabs = array();
    public $ip;

    public function __construct($ip = null)
    {
        //check if options exist
        if (!$this->getOptions()) {
            $this->setDefaultOptions();
        }
        $this->options = $this->getOptions();
        $this->ip = $ip;

    }

    public function getTabs()
    {
        return array(
            'login_protection' => array(
                'name' => __("Login protection", TWS_PREFIX),
                'view' => "loginprotection",
            ),
            '404_detection'    => array(
                'name' => __("404 detection", TWS_PREFIX),
                'view' => "error404",
            ),
            'ip_banning'       => array(
                'name' => __("IP banning", TWS_PREFIX),
                'view' => "banning",
            ),
            'logs'             => array(
                'name' => __("Logs", TWS_PREFIX),
                'view' => "logs",
            ),

        );
    }

    public function getOptions()
    {
        return get_site_transient(TWS_PREFIX . "_ip_lockouts_options");
    }

    public function setDefaultOptions($options = array())
    {
    	$is_empty_options = empty($options);
        if ($is_empty_options) {
            $options = $this->getDefaultOptions();
        }

        set_site_transient(TWS_PREFIX . "_ip_lockouts_options", $options);
    }


    public function save($option_name = "", $option_value = "")
    {
        $settings = $this->getOptions();
        if ($option_name == "" && $option_value == "") {
            foreach ($settings as $setting_key => $setting) {
                if (isset($_POST[$setting_key])) {
                    if ($setting_key == "ban_usernames" || $setting_key == "404_whitelist" || $setting_key == "404_ignore_file_types" || $setting_key == "ip_banning_blacklist" || $setting_key == "ip_banning_whitelist") {
                        $setting = explode(PHP_EOL, $_POST[$setting_key]);
                        $setting = array_map('trim', $setting);

                        if ($setting_key == "ip_banning_blacklist" || $setting_key == "ip_banning_whitelist") {
                            $setting = array_filter($setting, function ($value) {
                                if (filter_var($value, FILTER_VALIDATE_IP)) {
                                    return $value;
                                }
                            });
                        }

                    } else {
                        $setting = $_POST[$setting_key];
                    }
                }

                $settings[$setting_key] = $setting;
            }
        } else {
            $settings[$option_name] = $option_value;
        }

        $this->setDefaultOptions($settings);
    }

    private function getDefaultOptions()
    {
        return array(
            "enable_login_protection"     => "0",
            "threshold_login_attempts"    => "5",
            "threshold_login_time_period" => "300",
            "login_lockout_time"          => "300",
            "login_lockout_message"       => "You have been locked out due to too many invalid login attempts.",
            "ban_usernames"               => "",
            "enable_404_detection"        => "0",
            "threshold_404_attempts"      => "5",
            "threshold_404_time_period"   => "300",
            "404_lockout_time"            => "300",
            "404_lockout_message"         => "You have been locked out due to too many attempts to access a file that doesn’t exist.",
            "404_whitelist"               => "",
            "404_ignore_file_types"       => "",
            "404_exclusions"              => "1",
            "ip_banning_blacklist"        => "",
            "ip_banning_lockout_message"  => "The administrator has blocked your IP from accessing this website.",
            "ip_banning_whitelist"        => "",

        );

    }

}