<?php
/**
 * Created by PhpStorm.
 * User: anna
 * Date: 9/13/17
 * Time: 7:58 PM
 */

namespace Models\Lockouts;


class FormFields
{

    public static function formFields($fields, $options)
    {
        foreach ($fields as $field_id => $field) { ?>
            <div
                class="tws-table-row">
                <div
                    class="tws-table-cell">
                    <label
                        for="<?php echo $field_id; ?>"
                        title="<?php echo $field["tooltip"]; ?>"><?php echo $field["label"]; ?>:
                    </label>
                </div>
                <div
                    class="tws-table-cell">
                    <?php if ($field["type"] == "text") { ?>
                        <input
                            type="text"
                            name="<?php echo $field_id; ?>"
                            id="<?php echo $field_id; ?>"
                            value="<?php echo $options[$field_id]; ?>"
                            class="<?php echo $field["classes"]; ?>"
                            <?php echo $field["attr"]; ?> >
                    <?php } else if ($field["type"] == "select") { ?>
                        <select
                            name="<?php echo $field_id; ?>"
                            id="<?php echo $field_id; ?>"
                            class="<?php echo $field["classes"]; ?>"
                            <?php echo $field["attr"]; ?> >
                            <?php foreach ($field["choices"] as $option) {
                                $selected = $options[$field_id] == $option["value"] ? "selected" : ""; ?>
                                <option
                                    value="<?php echo $option["value"]; ?>" <?php echo $selected; ?>><?php echo $option["label"]; ?></option>
                            <?php } ?>
                        </select>
                    <?php } else if ($field["type"] == "radio") { ?>
                        <?php for ($i = 0; $i < count($field["choices"]); $i++) {
                            $option = $field["choices"][$i];
                            $checked = $options[$field_id] == $option["value"] ? "checked" : ""; ?>
                            <input
                                type="radio"
                                name="<?php echo $field_id; ?>"
                                id="<?php echo $field_id . $i; ?>"
                                value="<?php echo $option["value"]; ?>"
                                class="<?php echo $option["classes"]; ?>"
                                <?php echo $option["attr"]; ?>
                                <?php echo $checked; ?> >
                            <label
                                for="<?php echo $field_id . $i; ?>"><?php echo $option["label"]; ?></label>
                        <?php } ?>

                    <?php } else if ($field["type"] == "textarea") { ?>
                        <textarea
                            name="<?php echo $field_id; ?>"
                            id="<?php echo $field_id; ?>"
                            class="<?php echo $field["classes"]; ?>"
                            <?php echo $field["attr"]; ?> ><?php echo is_array($options[$field_id]) ? implode(PHP_EOL, $options[$field_id]) : $options[$field_id]; ?></textarea>
                    <?php } else if ($field["type"] == "import") { ?>
                        <input type="text" class="tws-elem-250 tws_imported_file" name="imported_file">
                        <button class="tws-btn tws-btn-secondary tws_open_media_library" onclick="TWS.openMedaiLibrary('tws_imported_file'); return false;"><?php _e("Select", TWS_PREFIX); ?></button>

                        <button class="tws-btn tws-btn-notprimary tws-lockouts-import" id="<?php echo $field_id; ?>"
                                data-do-action="tws_import" onclick="return false;"><?php _e("Import", TWS_PREFIX);?>
                        </button>
                    <?php } else if ($field["type"] == "export") { ?>
                        <a href="<?php echo admin_url("admin.php?page=tws_ip_lockouts&tws_action=export&nonce_tws=".wp_create_nonce('nonce_' . TWS_PREFIX));?>" download class="tws-btn tws-btn-notprimary tws-lockouts-export"" id="<?php echo $field_id; ?>"><?php echo _e("Export", TWS_PREFIX);?>
                        </a>
                    <?php }
                    if ($field["help_text"] != "") { ?>
                        <br>
                        <small><?php echo $field["help_text"]; ?></small>
                    <?php } ?>
                </div>
            </div>

        <?php }
    }
}