<?php

namespace Models\Lockouts;

use Models\Lockouts\Lockouts as Model;

class Error404 extends Model
{

    public $enable_404_detection = 0;
    public $threshold_attempts = 5;
    public $threshold_time_period = 5;
    public $lockout_time = 5;
    public $whitelist = array();
    public $lockout_message = "You have been locked out due to too many attempts to access a file that doesn’t exist.";
    public $ignore_file_types = array();
    public $exclusions = 0;

    public function __construct($ip = null)
    {
        parent::__construct($ip);

        $this->enable_404_detection = $this->options["enable_404_detection"];
        $this->threshold_attempts = $this->options["threshold_404_attempts"];
        $this->threshold_time_period = $this->options["threshold_404_time_period"];
        $this->lockout_time = $this->options["404_lockout_time"];
        $this->whitelist = (array)$this->options["404_whitelist"];
        $this->lockout_message = $this->options["404_lockout_message"];
        $this->ignore_file_types = (array)$this->options["404_ignore_file_types"];
        $this->exclusions = $this->options["404_exclusions"];
    }

    public static function getSettings()
    {
        return array(
            "enable_404_detection"   => array(
                "type"      => "radio",
                "choices"   => array(
                    0 => array(
                        "label"   => __("No", TWS_PREFIX),
                        "value"   => 0,
                        "classes" => "",
                        "attr"    => "",
                    ),
                    1 => array(
                        "label"   => __("Yes", TWS_PREFIX),
                        "value"   => 1,
                        "classes" => "",
                        "attr"    => "",
                    ),

                ),
                "label"     => __("Enable 404 detection", TWS_PREFIX),
                "help_text" => "",
                "tooltip"   => __("Enable 404 detection.", TWS_PREFIX),
            ),
            "threshold_404_attempts" => array(
                "type"      => "text",
                "label"     => __("How many 404 errors will trigger a lockout", TWS_PREFIX),
                "classes"   => "tws-elem-250",
                "attr"      => "",
                "help_text" => "",
                "tooltip"   => __("How many 404 errors will trigger a lockout", TWS_PREFIX),
            ),

            "threshold_404_time_period" => array(
                "type"      => "text",
                "label"     => __("What time period for 404 errors will trigger a lockout", TWS_PREFIX),
                "classes"   => "tws-elem-250",
                "attr"      => "",
                "help_text" => __("seconds", TWS_PREFIX),
                "tooltip"   => __("What time period for 404 errors will trigger a lockout", TWS_PREFIX),
            ),
            "404_lockout_time"          => array(
                "type"      => "text",
                "label"     => __("Lockout time", TWS_PREFIX),
                "classes"   => "tws-elem-250",
                "attr"      => "",
                "help_text" => __("seconds", TWS_PREFIX),
                "tooltip"   => __("Lockout time", TWS_PREFIX),
            ),
            "404_lockout_message"       => array(
                "type"      => "textarea",
                "label"     => __("Lockout message", TWS_PREFIX),
                "classes"   => "tws-elem-450",
                "attr"      => "rows=4",
                "help_text" => "",
                "tooltip"   => __("Lockout message", TWS_PREFIX),
            ),
            "404_whitelist"             => array(
                "type"      => "textarea",
                "label"     => __("Whitelist", TWS_PREFIX),
                "classes"   => "tws-elem-450",
                "attr"      => "rows=8",
                "help_text" => "",
                "tooltip"   => __("Whitelist", TWS_PREFIX),
            ),
            "404_ignore_file_types"     => array(
                "type"      => "textarea",
                "label"     => __("Ignore file types", TWS_PREFIX),
                "classes"   => "tws-elem-450",
                "attr"      => "rows=8",
                "help_text" => "",
                "tooltip"   => __("Ignore file types", TWS_PREFIX),
            ),
            "404_exclusions"            => array(
                "type"      => "radio",
                "choices"   => array(
                    0 => array(
                        "label"   => __("No", TWS_PREFIX),
                        "value"   => 0,
                        "classes" => "",
                        "attr"    => "",
                    ),
                    1 => array(
                        "label"   => __("Yes", TWS_PREFIX),
                        "value"   => 1,
                        "classes" => "",
                        "attr"    => "",
                    ),

                ),
                "label"     => __("Don't detect 404s for logged in users", TWS_PREFIX),
                "help_text" => "",
                "tooltip"   => __("Don't detect 404s for logged in users", TWS_PREFIX),
            ),
        );
    }

}