<?php
/**
 * Created by PhpStorm.
 * User: anna
 * Date: 9/13/17
 * Time: 6:53 PM
 */

namespace Models\Lockouts;

use Models\Lockouts\Lockouts as Model;

class Banning extends Model
{
    public $blacklist = array();
    public $whitelist = array();
    public $lockout_message = "The administrator has blocked your IP from accessing this website.";

    public function __construct($ip = null)
    {
        parent::__construct($ip);
        $options = (array)$this->options;
        $this->blacklist = $options["ip_banning_blacklist"];
        $this->whitelist = $options["ip_banning_whitelist"];
        $this->lockout_message = $options["ip_banning_lockout_message"];
    }

    public function addBlacklistPermanently($ips)
    {
        $ips = is_array($ips) ? $ips : array($ips);
        $ips = array_merge($this->blacklist, $ips);
        $blacklist = array_unique($ips);
        $this->save("ip_banning_blacklist", $blacklist);
    }

    public function removeFromBlacklistPermanently($ips)
    {
        $ips = is_array($ips) ? $ips : array($ips);
        $ips = array_diff($this->blacklist, $ips);
        $blacklist = array_unique($ips);
        $this->save("ip_banning_blacklist", $blacklist);
    }

    public function addBlacklistTemporary($time, $type)
    {
        $temp_blacklist = $this->getWpOption(TWS_PREFIX . "_tmp_blacklist");
        $temp_blacklist[] = array(
            "lockout_time" => $time,
            "ip"           => $this->ip,
            "type"         => $type,
            "created"      => time(),
        );

        $this->setWpOption(TWS_PREFIX . "_tmp_blacklist", $temp_blacklist);

    }

    public function updateBlackListTemporary()
    {
        $temp_blacklist = (array) $this->getWpOption(TWS_PREFIX . "_tmp_blacklist");

        if($temp_blacklist){
            $temp_blacklist = array_filter($temp_blacklist, function ($value) {
                if ($value["created"] + $value["lockout_time"] > time()) {
                    return $value;
                }
            });
            $this->setWpOption(TWS_PREFIX . "_tmp_blacklist", $temp_blacklist);
        }

        return $temp_blacklist;
    }

    public function getBlackListTemporary($type = null)
    {
        $temp_blacklist = $this->updateBlackListTemporary();
        if ($type !== null && $temp_blacklist) {
            $temp_blacklist = array_filter($temp_blacklist, function ($value) use ($type) {
                if ($value["type"] == $type) {
                    return $value;
                }
            });

        }
        $ips = array();
        foreach($temp_blacklist as $value){
            $ips[] = $value["ip"];
        }
        return $ips;
    }

    public function addWhitelist($ips)
    {
        $ips = is_array($ips) ? $ips : array($ips);
        $ips = array_merge($this->whitelist, $ips);
        $whitelist = array_unique($ips);
        $this->save("ip_banning_whitelist", $whitelist);
    }

    public function removeFromWhitelist($ips)
    {
        $ips = is_array($ips) ? $ips : array($ips);
        $ips = array_diff($this->whitelist, $ips);
        $whitelist = array_unique($ips);
        $this->save("ip_banning_whitelist", $whitelist);
    }


    public function export()
    {
        $csv = fopen('php://output', 'w');
        // add blacklist data
        foreach ($this->blacklist as $ip) {
            $row = array($ip, "blacklist");
            fputcsv($csv, $row);
        }

        // add whitelist data
        foreach ($this->whitelist as $ip) {
            $row = array($ip, "whitelist");
            fputcsv($csv, $row);
        }
        $file_name = "ips_" . time() . ".csv";
        header('Content-Type: text/csv');
        header('Content-Disposition: attachment; filename="' . $file_name . '";');
        header('Pragma: no-cache');
        header("Expires: 0");

        fclose($csv);
        exit();
    }

    public function import()
    {
        $file = isset($_POST["imported_file"]) ? $_POST["imported_file"] : "";
        if ($file) {
            $fp = fopen($file, 'r');
            $ips = array(
                "whitelist" => array(),
                "blacklist" => array(),
            );
            while (($row = fgetcsv($fp)) !== false) {
                if (count($row) != 2) {
                    return false;
                }
                if (!($row[1] == "whitelist" || $row[1] == "blacklist")) {
                    return false;
                }
                if (filter_var($row[0], FILTER_VALIDATE_IP)) {
                    $ips[$row[1]][] = $row[0];
                }
            }
            fclose($fp);
        }

        // add to blcklist
        if (count($ips['blacklist']) > 0) {
            $this->addBlacklistPermanently($ips['blacklist']);
        }

        // add to whitelist
        if (count($ips['whitelist']) > 0) {
            $this->addWhitelist($ips['whitelist']);
        }
    }

    public static function getSettings()
    {
        return array(
            "ip_banning_blacklist"       => array(
                "type"      => "textarea",
                "label"     => __("Blacklist", TWS_PREFIX),
                "classes"   => "tws-elem-450",
                "attr"      => "rows=8",
                "help_text" => __("Choose which IP addresses you wish to permanently ban from accessing your website.", TWS_PREFIX),
                "tooltip"   => __("Blacklist", TWS_PREFIX),
            ),
            "ip_banning_lockout_message" => array(
                "type"      => "textarea",
                "label"     => __("Lockout message", TWS_PREFIX),
                "classes"   => "tws-elem-450",
                "attr"      => "rows=4",
                "help_text" => "",
                "tooltip"   => __("Lockout message", TWS_PREFIX),
            ),
            "ip_banning_whitelist"       => array(
                "type"      => "textarea",
                "label"     => __("Whitelist", TWS_PREFIX),
                "classes"   => "tws-elem-450",
                "attr"      => "rows=8",
                "help_text" => "",
                "tooltip"   => __("Whitelist", TWS_PREFIX),
            ),
            "ip_banning_import"          => array(
                "type"      => "import",
                "label"     => __("Import", TWS_PREFIX),
                "classes"   => "",
                "attr"      => "",
                "help_text" => "",
                "tooltip"   => __("Import", TWS_PREFIX),
            ),
            "ip_banning_export"          => array(
                "type"      => "export",
                "label"     => __("Export", TWS_PREFIX),
                "classes"   => "",
                "attr"      => "",
                "help_text" => "",
                "tooltip"   => __("Export", TWS_PREFIX),
            ),
        );
    }
}