<?php

namespace Models;


class BaseModel
{

    public function getWpConfigPath()
    {
        if (file_exists(ABSPATH . 'wp-config.php')) {
            return ABSPATH . 'wp-config.php';
        }

        return false;
    }

    public function getWpConfigInsertLine($config)
    {
        $needle = "(^define\(\s*['|\"]WP_DEBUG['|\"]\s*,(.*)\))";

        foreach ($config as $line_num => $line) {
            if (preg_match($needle, $line, $matches)) {
                return $line_num;
            }
        }

        return false;
    }

}