<?php
/**
 * Created by PhpStorm.
 * User: araqel
 * Date: 9/13/17
 * Time: 5:35 PM
 */

namespace Controllers;


use Models\Tweaks\ChangeDefaultUserAccount;
use Models\Tweaks\ChangePrefix;
use Models\Tweaks\DisableEditor;
use Models\Tweaks\DisableTrackbacks;
use Models\Tweaks\ErrorReporting;
use Models\Tweaks\LoginDuration;
use Models\Tweaks\PhpVersion;
use Models\Tweaks\PreventInformationDisclosure;
use Models\Tweaks\PreventPhpExecution;
use Models\Tweaks\SecurityKeys;
use Models\Tweaks\Tweaks;

class TweaksController extends BaseController
{
    protected $tabs = array();
    public $status = array();
    public $page = null;
    public $remind_periods = array();

    private $tweaks = array(
        'disable_trackbacks'  => DisableTrackbacks::class,
        'change_default_user' => ChangeDefaultUserAccount::class,
        'php_version'         => PhpVersion::class,
        'disable_editor'      => DisableEditor::class,
        'error_reporting'     => ErrorReporting::class,
        'login_duration'      => LoginDuration::class,
        'change_prefix'       => ChangePrefix::class,
        'security_keys'       => SecurityKeys::class,
        'prevent_information_disclosure' => PreventInformationDisclosure::class,
        'prevent_php_execution' => PreventPhpExecution::class,
    );

    public function __construct($model)
    {
        $this->page = TWS_PREFIX . '_security_tweaks';
        $this->remind_periods = array(
            30 * DAY_IN_SECONDS  => '30 Days',
            60 * DAY_IN_SECONDS  => '60 Days',
            90 * DAY_IN_SECONDS  => '90 Days',
            6 * MONTH_IN_SECONDS => '6 Months',
            1 * YEAR_IN_SECONDS  => '1 Year'
        );
        $this->getTabs();
        if (isset($_POST[TWS_PREFIX . '_action']) && $_REQUEST['page'] == $this->page) {
            $this->doAction($_POST[TWS_PREFIX . '_action']);
        }
        parent::__construct($model);
    }

    public function getTabs()
    {
        $tabs = Tweaks::$tabs;
        foreach ($this->tweaks as $view => $tweakClass) {
            $tweak = new $tweakClass;
            if ($status = $tweak->checkStatus())
                $tabs[$status]['views'][] = $view;
            $this->status[$view] = $status;
        }

        $this->tabs = $tabs;
    }

    public function check($needle)
    {
        $view_name = basename($this->view);
        if (isset($this->status[$view_name]) && $this->status[$view_name] == $needle) {
            return true;
        }

        return false;
    }

    public function doAction($action)
    {

        if (!isset($this->tweaks[$_POST[TWS_PREFIX . '_action_class']])) {
            return false;
        }

        $tweak = new $this->tweaks[$_POST[TWS_PREFIX . '_action_class']]();
        $tweak->$action();

        wp_redirect('admin.php?page=' . TWS_PREFIX . '_security_tweaks');

    }


    public function doActionAjax()
    {
        $action = isset($_POST[TWS_PREFIX . '_action']) ? $_POST[TWS_PREFIX . '_action'] : false;

        if (!$action) {
            return false;
        }

        if (!isset($this->tweaks[$_POST[TWS_PREFIX . '_action_class']])) {
            return false;
        }

        $tweak = new $this->tweaks[$_POST[TWS_PREFIX . '_action_class']]();
        $tweak->$action();
        exit;
    }
}