<?php

namespace Controllers;

use Models\Scan;


class ScannerController extends BaseController
{

    public function getScanData()
    {
        $scan = new Scan();
        global $wp_version;
        $themes = $scan->getThemes();
        $core_themes = $scan->getCoreThemes();
        $plugins = $scan->getPlugins();
        $core_hashes = $scan->getHashes();

        $plugin_hashes = array();
        foreach ($plugins as $slug => $plugin) {
            if (false !== $hashes = $scan->getHashes('plugin', $slug)) {
                $plugin_hashes[$slug] = $hashes;
            }
        }

        $theme_hashes = array();
        foreach ($themes as $slug => $theme) {

            if (false !== $hashes = $scan->getHashes('theme', $slug)) {
                $theme_hashes[$slug] = $hashes;
            }
        }

        return array(
            "plugins"       => $plugins,
            "themes"        => $themes,
            "core_themes"   => $core_themes,
            "core_hashes"   => $core_hashes,
            "plugin_hashes" => $plugin_hashes,
            "theme_hashes"  => $theme_hashes,
            "wp_version"    => $wp_version,
            "abs_path"      => ABSPATH,
        );
    }


    public function restoreFileToOriginal()
    {
        $request = $this->request;

        $file = $request->get_param('file');
        $type = $request->get_param('type');
        $version = $request->get_param('version');
        $slug = $request->get_param('slug');

        $scan = new Scan();
        $replace = $scan->replaceToOrigFile($file, $type, $version, $slug);
        if ($replace != false) {
            return true;
        }

        return false;

    }

    public function getDiff()
    {
        $request = $this->request;
        $file = $request->get_param('file');
        $file_status = $request->get_param('file_status');
        $type = $request->get_param('type');
        $version = $request->get_param('version');
        $slug = $request->get_param('slug');

        $file = ABSPATH . '/' . $file;
        $scan = new Scan();
        $file_data = $scan->getDiff($file, $type, $version, $slug, $file_status);
        $file_size = 0;
        $file_time = '';
        if ($file_status != "missing_file") {
            $file_size = filesize($file);
            $file_time = filemtime($file);
        }


        return array(
            "diff"          => $file_data["diff"],
            "original_file" => $file_data["original_file"],
            "file"          => $file_data["file"],
            "file_size"     => $file_size,
            "file_time"     => $file_time
        );

    }

}