<?php
/**
 * Created by PhpStorm.
 * User: anna
 * Date: 9/13/17
 * Time: 5:33 PM
 */

namespace Controllers;

use Models\Lockouts\Banning;
use Models\Lockouts\Error404;
use Models\Lockouts\LoginProtection;
use Models\Lockouts\Lockouts;
use Models\Lockouts\Logs;

class LockoutsController extends BaseController
{
    public $ip_settings = array();
    public $error404_settings = array();
    public $ip_banning_settings = array();
    public $tabs = array();
    public $options = array();
    public $logs = null;
    public $logs_total = 0;
    public $page = null;


    private $models = array(
        "lockouts"         => Lockouts::class,
        "login_protection" => LoginProtection::class,
        "log"              => Logs::class,
        "banning"          => Banning::class,
        "error404"         => Error404::class,
    );

    public function __construct($model)
    {
        $this->init_models();
        $this->page = TWS_PREFIX . "_ip_lockouts";
        parent::__construct($model);

        if (isset($_REQUEST[TWS_PREFIX . '_action']) && $_REQUEST['page']==$this->page) {
            $this->doAction($_REQUEST[TWS_PREFIX . '_action']);
        }

        $this->tabs = $this->lockouts->getTabs();
        $this->options = $this->lockouts->getOptions();

        $this->ip_settings = LoginProtection::getSettings();
        $this->error404_settings = Error404::getSettings();
        $this->ip_banning_settings = Banning::getSettings();

        $this->logs = $this->log->getLogs();
        $this->logs_total = $this->log->getLogsTotal();

    }

    public function save()
    {
        $this->lockouts->save();
    }

    public function ban()
    {
        $ip = isset($_REQUEST["ip"]) ? $_REQUEST["ip"] : "";
        if ($ip) {
            $this->banning->addBlacklistPermanently($ip);
        }
    }

    public function unban()
    {
        $ip = isset($_REQUEST["ip"]) ? $_REQUEST["ip"] : "";
        if ($ip) {
            $this->banning->removeFromBlacklistPermanently($ip);
        }
    }

    public function whitelist()
    {
        $ip = isset($_REQUEST["ip"]) ? $_REQUEST["ip"] : "";
        if ($ip) {
            $this->banning->addWhitelist($ip);
        }
    }

    public function unwhitelist()
    {
        $ip = isset($_REQUEST["ip"]) ? $_REQUEST["ip"] : "";
        if ($ip) {
            $this->banning->removeFromWhitelist($ip);
        }
    }

    public function export()
    {
        $this->banning->export();
    }

    public function import()
    {
        $this->banning->import();
    }

    public function logs_filter()
    {
        $this->logs = $this->log->getLogs();
        $this->load("lockouts/logs");
    }

    private function init_models()
    {
        foreach ($this->models as $prop_name => $model) {
            $this->$prop_name = new $model();
        }
    }


}