<?php

/**
 * Plugin Name: 10Web Security
 * Plugin URI: https://10web.io/services/security/
 * Description: The bulletproof method for dodging malware. Get unlimited scans for file changes and vulnerabilities, easy restore of original files, and more.
 * Version: 5.0.22
 * Author: 10Web
 * Author URI: https://10web.io/
 * License: GNU/GPLv3 http://www.gnu.org/licenses/gpl-3.0.html
 */

define('TWS_DIR', WP_PLUGIN_DIR . "/" . plugin_basename(dirname(__FILE__)));
define('TWS_URL', plugins_url(plugin_basename(dirname(__FILE__))));
define('TWS_URL_IMG', TWS_URL . '/assets/img');

define('TWS_NAME', plugin_basename(dirname(__FILE__)));
define('TWS_MAIN_FILE', plugin_basename(__FILE__));
define('TWS_PREFIX', "tws");
define('TWS_API_URL', "https://security.10web.io/api/");
define('TWS_MANAGER_PREFIX', "tenweb");



if (version_compare(phpversion(), "5.5", '>')) {


    require_once('vendor/autoload.php');
    if (is_admin() || (defined('DOING_CRON') && DOING_CRON)) {

        require_once('tws_class.php');

        register_activation_hook(__FILE__, array('TWS', 'activate'));
        add_action('plugins_loaded', array('TWS', 'getInstance'));

        register_deactivation_hook(__FILE__, array('TWS', 'deactivate'));

    }

    /*require_once('tws_ip_lockouts.php');
    add_action('plugins_loaded', array('TWS_IP_Lockouts', 'get_instance'));

    require_once('tws_tweaks.php');
    add_action('plugins_loaded', array('TWS_Tweaks', 'getInstance'));
    */

    if (class_exists("WP_REST_Controller")) {
        require_once('tws-rest.php');
        add_action('rest_api_init', function () {
            $rest = new TWS_Rest();
            $rest->register_routes();
        });
    }
} else {
    add_action('admin_notices', 'tws_php_version_admin_notice');
    deactivate_plugins(TWS_MAIN_FILE);

}


function tws_php_version_admin_notice()
{
    ?>
    <div class="notice notice-error">
        <h3>10web Security</h3>
        <p><?php _e('This version of the plugin requires PHP 5.6.0 or higher.', 'tws'); ?></p>
        <p><?php _e('We recommend you to update PHP or ask your hosting provider to do that.', 'tws'); ?></p>
    </div>
    <?php
}

