<?php

class TWIPBanning
{
    private $ip = null;
    private $blacklist = array();
    private $temp_blacklist = array();

    public function __construct($ip = null)
    {
        $this->ip = $ip;

        $this->blacklist = $this->getBannedIps();
        $this->temp_blacklist = $this->getBannedIps(true);
    }

    public function getBlackList()
    {
        return $this->blacklist;
    }

    public function getTempBlackList()
    {
        return $this->temp_blacklist;
    }

    public function checkIfIpInBlacklist()
    {
        if (isset($this->blacklist[$this->ip])) {
            $diff = (strtotime(date("Y-m-d H:i:s")) - $this->blacklist[$this->ip]["created_at"]);
            if ($diff < TW_LOCKOUT_TIME) {
                return true;
            } else {
                $this->remove();
            }
        }

        return false;

    }

    public function checkIfIpInTempBlacklist()
    {
        if (isset($this->temp_blacklist[$this->ip])) {
            $diff = (strtotime(date("Y-m-d H:i:s")) - $this->temp_blacklist[$this->ip]["created_at"]);
            if ($diff < TW_FAILED_ATTEMPTS_TIME) {
                return true;
            } else {
                $this->removeTemp();
            }
        }

        return false;
    }


    public function add()
    {
        $this->blacklist[$this->ip] = array(
            "ip"         => $this->ip,
            "created_at" => time(),
        );
        $this->updateBannedIps($this->blacklist);
    }

    public function remove()
    {
        if (isset($this->blacklist[$this->ip])) {
            unset($this->blacklist[$this->ip]);
        }
        $this->updateBannedIps($this->blacklist);
    }

    public function addTemp()
    {
        $count = 0;
        $created_at = time();
        if ($this->checkIfIpInTempBlacklist()) {
            $count = $this->temp_blacklist[$this->ip]["count"];
            $created_at = $this->temp_blacklist[$this->ip]["created_at"];
        }
        $this->temp_blacklist[$this->ip] = array(
            "ip"         => $this->ip,
            "count"      => ($count + 1),
            "created_at" => $created_at,
        );
        $this->updateBannedIps($this->temp_blacklist, true);

        return $this->temp_blacklist[$this->ip];
    }

    public function removeTemp()
    {
        if (isset($this->temp_blacklist[$this->ip])) {
            unset($this->temp_blacklist[$this->ip]);
        }
        $this->updateBannedIps($this->temp_blacklist, true);
    }

    public function setIp($ip)
    {
        $this->ip = $ip;
    }

    private function getBannedIps($temp = false)
    {
        global $wpdb;
        $option_name = 'tw_banned_ips_';
        if ($temp) {
            $option_name = 'tw_temp_banned_ips_';
        }
        $results = $wpdb->get_results('SELECT option_value FROM ' . $wpdb->prefix . 'options
         WHERE option_name LIKE "%' . $option_name . '%"', ARRAY_A);
        $ips = array();
        foreach ($results as $result) {
            $result = unserialize($result['option_value']);
            $ips = $ips + $result;
        }

        return $ips;
    }

    private function updateBannedIps($data, $temp = false)
    {
        $option_name = 'tw_banned_ips_';
        if ($temp) {
            $option_name = 'tw_temp_banned_ips_';
        }
        $index = 0;
        do {
            $saved = array_slice($data, 0, TW_BLACKLIST_OPTION_SIZE, true);
            update_site_option($option_name . $index, $saved);
            $data = array_slice($data, TW_BLACKLIST_OPTION_SIZE, count($data), true);
            $index++;
        } while ($data);

        // if there is option which is no need anymore, delete it
        delete_site_option($option_name . $index);
    }
}
