<?php

namespace TmdHelper\App\Api\Maintenance;

use TmdHelper\App\Interfaces\ApiInterface;
use WP_REST_Controller, WP_REST_Request, WP_Error, WP_REST_Server, WP_REST_Response;

class MaintenanceApi extends WP_REST_Controller implements ApiInterface
{
    const NAMESPACE = 'wp/v2';
    const BASE_ROUTE = '/maintenance';

    /**
     * @var MaintenanceManager
     */
    protected $maintenanceManager;

    /**
     * MaintenanceApi constructor.
     */
    public function __construct()
    {
        $this->maintenanceManager = new MaintenanceManager();
    }

    public function registerFields(){}


    public function registerRoutes()
    {
        // activate
        register_rest_route(
            self::NAMESPACE,
            self::BASE_ROUTE . '/activate',
            [
                [
                    'methods' => WP_REST_Server::CREATABLE,
                    'callback' => [$this, 'activateMaintenanceMode']
                ],
            ]
        );

        // deactivate
        register_rest_route(
            self::NAMESPACE,
            self::BASE_ROUTE . '/deactivate',
            [
                [
                    'methods' => WP_REST_Server::CREATABLE,
                    'callback' => [$this, 'deactivateMaintenanceMode']
                ],
            ]
        );

        // update
        register_rest_route(
            self::NAMESPACE,
            self::BASE_ROUTE . '/update',
            [
                [
                    'methods' => WP_REST_Server::CREATABLE,
                    'callback' => [$this, 'activateMaintenanceMode']
                ],
            ]
        );
    }

    public function activateMaintenanceMode(WP_REST_Request $request)
    {
        try {
            $this->validateRequestParameters($request);
            $bodyParams = $request->get_body_params();
            $description = !isset($bodyParams['description']) ? '' : $bodyParams['description'];
            $this->maintenanceManager->activateMaintenanceMode(
                (int)$bodyParams['templateStyle'],
                (string)$bodyParams['heading'],
                (string)$bodyParams['title'],
                (string)$description,
                (string)$bodyParams['endDate']
            );
        } catch (\Exception $exception) {
            return new WP_REST_Response([
                'status'  => 'error',
                'message' => $exception->getMessage()
            ], 400);
        }
        return new WP_REST_Response([
            'status'    => 'success',
        ],200);
    }

    public function deactivateMaintenanceMode(WP_REST_Request $request)
    {
        try {
            $this->maintenanceManager->deactivateMaintenanceMode();
        } catch (\Exception $exception) {
            return new WP_REST_Response([
                'status'    => 'error',
                'message'   => $exception->getMessage()
            ], 400);
        }
        return new WP_REST_Response([
            'status'    => 'success',
        ], 200);
    }

    /**
     * @param WP_REST_Request $request
     * @return bool
     * @throws \Exception
     */
    protected function validateRequestParameters(WP_REST_Request $request)
    {
        $errorMessage = null;
        $bodyParams = $request->get_body_params();
        if (!isset($bodyParams['templateStyle']) || empty($bodyParams['templateStyle'])) {
            $errorMessage = "Please specify a 'templateStyle' parameter (can be 1|2|3|4)";
        }
        if (!isset($bodyParams['heading']) || empty($bodyParams['heading'])) {
            $errorMessage = "Please specify a 'heading'";
        }
        if (!isset($bodyParams['title']) || empty($bodyParams['title'])) {
            $errorMessage = "Please specify a 'title'";
        }

        if ($errorMessage) {
            throw new \Exception($errorMessage);
        }

        return true;
    }
}
