<?php

namespace TmdHelper\App\Api;

use TmdHelper\App\Api\Maintenance\MaintenanceApi;
use TmdHelper\App\Api\Cloudflare\CloudflareApi;
use TmdHelper\App\Api\Matomo\MatomoConfiguratorApi;
use TmdHelper\App\Api\Media\MediaApi;
use TmdHelper\App\Api\Secure\SecureApi;
use TmdHelper\App\Api\Signon\SignonApi;
use TmdHelper\App\Api\Templates\TemplatesApi;
use WP_REST_Controller;
use TmdHelper\App\Api\Settings\SettingsApi;
use TmdHelper\App\Api\Users\UsersApi;

/**
 * Wrapper for registering routes
 */
class EndpointInitializer extends WP_REST_Controller
{
    /**
     * @var Reference/wpdb
     */
    protected $wpdb;
    /**
     * Registered APIs must be instantiated in __construct()
     * @var array
     */
    protected $apis = [];

    /**
     * Matomo_Configurator_API constructor.
     */
    public function __construct()
    {
        global $wpdb;
        $this->wpdb = $wpdb;
        $this->apis[] = new SettingsApi();
        $this->apis[] = new UsersApi();
        $this->apis[] = new MatomoConfiguratorApi();
        $this->apis[] = new MaintenanceApi();
        $this->apis[] = new TemplatesApi();
        $this->apis[] = new MediaApi();
        $this->apis[] = new SignonApi();
        $this->apis[] = new SecureApi();
        $this->apis[] = new CloudflareApi();
    }

    /**
     * Registers routes
     */
    public function registerRoutes(){
        foreach ($this->apis as $api){
            $api->registerRoutes();
        }
    }

    /**
     * Registers fields
     */
    public function registerFields(){
        foreach ($this->apis as $api){
            $api->registerFields();
        }
    }
}
