<?php

namespace TmdHelper\App\Api\Users;

use WP_REST_Controller;
use TmdHelper\App\Interfaces\ApiInterface;

/**
 * Class UsersApi
 */
class UsersApi extends WP_REST_Controller implements ApiInterface
{

    /**
     * Register the routes for the objects of the controller.
     */
    public function registerRoutes()
    {

    }

    /**
     * Register the field total_posts for user endpoint.
     */
    public function registerFields()
    {

        register_rest_field( 'user', 'total_posts', array(
                'get_callback'    => [$this, 'getCountUserPosts'],
            )
        );
        register_rest_field( 'user', 'total_users', array(
                'get_callback'    => [$this, 'getTotalUsers'],
            )
        );
    }

    /**
     * @param $user
     * @return int
     */
    public function getCountUserPosts($user)
    {
        return (int) count_user_posts($user['id']);
    }

    /**
     * @return integer
     */

    public function getTotalUsers()
    {
        $countOfUsers = count_users();
        return  $countOfUsers['total_users'];
    }
}
