<?php

namespace TmdHelper\App\Api\Secure;

use TmdHelper\App\Interfaces\ApiInterface;
use WP_REST_Controller, WP_REST_Request, WP_Error, WP_REST_Server, WP_REST_Response;

class SecureApi extends WP_REST_Controller implements ApiInterface
{
    const NAMESPACE = 'wp/v2';
    const BASE_ROUTE = '/secure';

    protected $secureManager;

    public function __construct()
    {
        $this->secureManager = new SecureManager();
    }

    public function registerFields()
    {
    }

    public function registerRoutes()
    {
        // fix secure headers
        register_rest_route(
            self::NAMESPACE,
            self::BASE_ROUTE . '/set-secure-headers',
            [
                [
                    'methods' => WP_REST_Server::CREATABLE,
                    'callback' => [$this, 'fixSecureHeaders']
                ],
            ]
        );
    }

    public function fixSecureHeaders($request)
    {
        try {
            $bodyParams = $request->get_body_params();
            $this->validateRequestParameters($bodyParams);
            $data = $this->secureManager->updateHeadersInHtaccess($bodyParams['headers'], 'Securi: Security Headers');
        } catch (\Exception $exception) {
            return new WP_REST_Response([
                'status' => 'error',
                'message' => $exception->getMessage()
            ], $exception->getCode());
        }

        return new WP_REST_Response(['headers' => $data], 200);
    }

    /**
     * @param array $bodyParams
     * @return bool
     * @throws \Exception
     */
    private function validateRequestParameters(array $bodyParams)
    {
        $errorMessage = null;
        if (!isset($bodyParams['headers']) || empty($bodyParams['headers'])) {
            $errorMessage = "Please specify a 'headers' array";
        }
        if ($errorMessage) {
            throw new \Exception($errorMessage);
        }

        return true;
    }
}
