<?php

namespace TmdHelper\App\Api\Matomo;

use TmdHelper\App\Interfaces\ApiInterface;
use WP_REST_Controller, WP_REST_Request, WP_Error, WP_REST_Server, WP_REST_Response;

/**
 * Class Matomo_Configurator_API
 */
class MatomoConfiguratorApi extends WP_REST_Controller implements ApiInterface
{
    /**
     * @var MatomoConfiguratorManager
     */
    protected $matomoConfigurator;

    /**
     * @var Reference/wpdb
     */
    protected $wpdb;

    /**
     * Matomo_Configurator_API constructor.
     */
    public function __construct()
    {
        global $wpdb;
        $this->wpdb = $wpdb;
    }

    /**
     * Register the routes for the objects of the controller.
     */
    public function registerRoutes()
    {
        $version = '2';
        $namespace = 'wp/v' . $version;
        $base = 'matomo/configure';
        register_rest_route(
            $namespace,
            '/' . $base,
            [
                [
                    'methods'             => WP_REST_Server::CREATABLE,
                    'callback'            => [$this, 'configure'],
                    'permission_callback' => [$this, 'get_items_permissions_check'],
                    'args'                => [
                        'key' => 'value',
                    ],
                ],
            ]
        );
    }

    public function registerFields(){}

    /**
     * @param WP_REST_Request $request Full data about the request.
     *
     * @return WP_Error|WP_REST_Response
     */
    public function configure($request)
    {
        $stausCode = 200;
        $status = 'Success';
        $errors = [];
        $payload = [];
        $bodyParams = $request->get_body_params();
        $this->initMatomoConfiguratorManager();
        try {
            $this->matomoConfigurator->setMatomoAddr($bodyParams['matomoAddr'])
                                     ->setMatomoToken($bodyParams['matomoToken'])
                                     ->setMatomoSiteId($bodyParams['matomoSiteId'])
                                     ->generateCodes()
                                     ->run();
        } catch (\Exception $e) {
            $stausCode = 400;
            $status = 'Error';
            $errors[] = $e->getMessage();
        }

        return new WP_REST_Response(['status' => $status, 'errors' => $errors, 'payload' => $payload], $stausCode);
    }

    /**
     * @param WP_REST_Request $request Full data about the request.
     *
     * @return WP_Error|bool
     */
    public function get_items_permissions_check($request)
    {
        $result = $this->wpdb->get_row(
            "SELECT * FROM {$this->wpdb->options} WHERE option_name = 'wp-piwik_global-piwik_url'",
            OBJECT
        );

        return empty($result->option_value);
    }

    /**
     * Initializes $matomoConfigurator
     */
    private function initMatomoConfiguratorManager()
    {
        $this->matomoConfigurator = new MatomoConfiguratorManager($this->wpdb);
    }
}
