<?php
/**
 * Plugin Name: TMD Helper plugin
 * Description: Plugin required for normal work of TMD services. Do not delete it
 * Version: 2.0.5
 */
// Make sure we don't expose any info if called directly
if ( !function_exists( 'add_action' ) ) {
    echo 'Hi there!  I\'m just a plugin, not much I can do when called directly.';
    exit;
}
require __DIR__ . '/vendor/autoload.php';

use TmdHelper\App\Functions\Loader;
use TmdHelper\App\Api\EndpointInitializer;

// Load files from functions dir
Loader::load();


// Register custom API endpoints
// For add new new endpoints - add needed to EndpointInitializer __construct method
$initializer = new EndpointInitializer();
add_action(
    'rest_api_init',
    function () use ($initializer) {
        $initializer->registerRoutes();
        $initializer->registerFields();
    }
);
