<?php

namespace TmdHelper\App\Api\Maintenance;

/**
 * Class MaintenanceManager
 * @package TmdHelper\App\Api\Maintenance
 */
class MaintenanceManager
{
    const TEMPLATES_PATH = __DIR__ . '/../../../resources/templates/maintenance';
    const MAINTENANCE_TEMPLATE_FILE_PATH = WP_CONTENT_DIR . '/maintenance.php';
    const WP_INCLUDES_DIR_PATH = ABSPATH . "/wp-includes";

    /**
     * @param int $templateStyle
     * @param string $heading
     * @param string $title
     * @param string $description
     * @param string $endDate
     */
    public function activateMaintenanceMode(
        int $templateStyle,
        string $heading,
        string $title,
        string $description,
        string $endDate
    ) {
        $templateDirPath = self::TEMPLATES_PATH . '/template-' . $templateStyle;
        $templateFullPath = $templateDirPath . '/index.html';

        // set template
        if (file_exists($templateFullPath)) {
            // remove old template file
            if (file_exists(self::MAINTENANCE_TEMPLATE_FILE_PATH)) {
                unlink(self::MAINTENANCE_TEMPLATE_FILE_PATH);
            }

            // move new file
            copy($templateFullPath, self::MAINTENANCE_TEMPLATE_FILE_PATH);
            // copy directory with css
            $destination = self::WP_INCLUDES_DIR_PATH . "/tmd-coming-soon-template";
            shell_exec("rm -rf $destination");
            shell_exec("cp -r $templateDirPath $destination");

            // insert variables
            $content = file_get_contents(self::MAINTENANCE_TEMPLATE_FILE_PATH);
            $includesUrl = includes_url() . "tmd-coming-soon-template";
            $content = str_replace(
                ['TMD_ASSETS_PATH','HEADING_FOR_REPLACE', 'TITLE_FOR_REPLACE', 'DESCRIPTION_FOR_REPLACE', 'END_DATE_TO_REPLACE'],
                [$includesUrl, $heading, $title, $description, $endDate],
                $content
            );
            file_put_contents(self::MAINTENANCE_TEMPLATE_FILE_PATH, $content);
        }
    }

    /**
     * Remove file from content directory
     */
    public function deactivateMaintenanceMode()
    {
        // remove template
        if (file_exists(self::MAINTENANCE_TEMPLATE_FILE_PATH)) {
            unlink(self::MAINTENANCE_TEMPLATE_FILE_PATH);
        }

        // remove dir with assets
        $destination = self::WP_INCLUDES_DIR_PATH . "/tmd-coming-soon-template";
        shell_exec("rm -rf $destination");
    }
}
