<?php

namespace TmdHelper\App\Api\Cloudflare;

use TmdHelper\App\Interfaces\ApiInterface;
use WP_REST_Controller, WP_REST_Request, WP_Error, WP_REST_Server, WP_REST_Response;

/**
 * Class Matomo_Configurator_API
 */
class CloudflareApi extends WP_REST_Controller implements ApiInterface
{
    /**
     * @var CloudflareManager
     */
    protected $cloudflareManager;

    /**
     * @var Reference/wpdb
     */
    protected $wpdb;

    /**
     * Matomo_Configurator_API constructor.
     */
    public function __construct()
    {
        global $wpdb;
        $this->wpdb = $wpdb;
    }

    /**
     * Register the routes for the objects of the controller.
     */
    public function registerRoutes()
    {
        $version = '2';
        $namespace = 'wp/v' . $version;
        $base = 'cloudflare/configure';
        register_rest_route(
            $namespace,
            '/' . $base,
            [
                [
                    'methods'             => WP_REST_Server::CREATABLE,
                    'callback'            => [$this, 'configure'],
                    'permission_callback' => [$this, 'get_items_permissions_check'],
                    'args'                => [
                        'key' => 'value',
                    ],
                ],
            ]
        );
    }

    public function registerFields(){}

    /**
     * @param WP_REST_Request $request Full data about the request.
     *
     * @return WP_Error|WP_REST_Response
     */
    public function configure($request)
    {
        $statusCode = 200;
        $status = 'Success';
        $errors = [];
        $payload = [];
        $bodyParams = $request->get_body_params();
        $this->initCloudflareManager();

        try {
            $this->cloudflareManager->setEmail($bodyParams['email']);
            $this->cloudflareManager->setApiKey($bodyParams['apiKey']);
            $this->cloudflareManager->run();
        } catch (\Exception $e) {
            $statusCode = 400;
            $status = 'Error';
            $errors[] = $e->getMessage();
        }

        return new WP_REST_Response(['status' => $status, 'errors' => $errors, 'payload' => $payload], $statusCode);
    }

    /**
     * @param WP_REST_Request $request Full data about the request.
     *
     * @return WP_Error|bool
     */
    public function get_items_permissions_check($request)
    {
        return true;
    }

    /**
     * Initializes $matomoConfigurator
     */
    private function initCloudflareManager()
    {
        $this->cloudflareManager = new CloudflareManager($this->wpdb);
    }
}
