<?php
// No direct access, please
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}

if ( ! function_exists( 'generate_menu_plus_setup' ) ) {
	add_action( 'after_setup_theme', 'generate_menu_plus_setup' );
	/**
	 * Register the slide-out menu
	 */
	function generate_menu_plus_setup() {
		register_nav_menus( array(
			'slideout' => __( 'Slideout Navigation', 'gp-premium' ),
		) );
	}
}

if ( ! function_exists( 'generate_menu_plus_get_defaults' ) ) {
	/**
	 * Set default options
	 */
	function generate_menu_plus_get_defaults() {
		$generate_menu_plus_get_defaults = array(
			'mobile_menu_label' => __( 'Menu', 'gp-premium' ),
			'sticky_menu' => 'false',
			'sticky_menu_effect' => 'fade',
			'sticky_menu_logo' => '',
			'sticky_menu_logo_position' => 'sticky-menu',
			'mobile_header' => 'disable',
			'mobile_header_logo' => '',
			'mobile_header_sticky' => 'disable',
			'slideout_menu' => 'false',
			'slideout_menu_side' => 'left',
			'auto_hide_sticky' => false,
			'mobile_header_auto_hide_sticky' => false,
		);

		return apply_filters( 'generate_menu_plus_option_defaults', $generate_menu_plus_get_defaults );
	}
}

add_filter( 'generate_color_option_defaults', 'generate_menu_plus_color_defaults' );
/**
 * Set the Menu Plus color defaults
 *
 * @since 1.6
 */
function generate_menu_plus_color_defaults( $defaults ) {
	$defaults[ 'slideout_background_color' ] = '';
	$defaults[ 'slideout_text_color' ] = '';
	$defaults[ 'slideout_background_hover_color' ] = '';
	$defaults[ 'slideout_text_hover_color' ] = '';
	$defaults[ 'slideout_background_current_color' ] = '';
	$defaults[ 'slideout_text_current_color' ] = '';
	$defaults[ 'slideout_submenu_background_color' ] = '';
	$defaults[ 'slideout_submenu_text_color' ] = '';
	$defaults[ 'slideout_submenu_background_hover_color' ] = '';
	$defaults[ 'slideout_submenu_text_hover_color' ] = '';
	$defaults[ 'slideout_submenu_background_current_color' ] = '';
	$defaults[ 'slideout_submenu_text_current_color' ] = '';

	return $defaults;
}

add_filter( 'generate_font_option_defaults', 'generate_menu_plus_typography_defaults' );
/**
 * Set the Menu Plus typography option defaults.
 *
 * @since 1.6
 */
function generate_menu_plus_typography_defaults( $defaults ) {
	$defaults[ 'slideout_font_weight' ] = 'normal';
	$defaults[ 'slideout_font_transform' ] = 'none';
	$defaults[ 'slideout_font_size' ] = '';
	$defaults[ 'slideout_mobile_font_size' ] = '';

	return $defaults;
}

if ( ! function_exists( 'generate_menu_plus_customize_register' ) ) {
	add_action( 'customize_register', 'generate_menu_plus_customize_register', 100 );
	/**
	 * Initiate Customizer controls
	 */
	function generate_menu_plus_customize_register( $wp_customize ) {
		// Get our defaults
		$defaults = generate_menu_plus_get_defaults();

		// Get our Customizer helpers
		require_once GP_LIBRARY_DIRECTORY . 'customizer-helpers.php';

		// Add our old Menu Plus panel
		// This panel shouldn't display anymore but is left for back compat
		if ( class_exists( 'WP_Customize_Panel' ) ) {
			if ( ! $wp_customize->get_panel( 'generate_menu_plus' ) ) {
				$wp_customize->add_panel( 'generate_menu_plus', array(
					'priority'       => 50,
					'capability'     => 'edit_theme_options',
					'theme_supports' => '',
					'title'          => esc_html__( 'Menu Plus', 'gp-premium' ),
					'description'    => '',
				) );
			}
		}

		// Add our options to the Layout panel if it exists
		// The layout panel is in the free theme, so we have the fallback in case people haven't updated
		if ( $wp_customize->get_panel( 'generate_layout_panel' ) ) {
			$panel = 'generate_layout_panel';
			$navigation_section = 'generate_layout_navigation';
			$header_section = 'generate_layout_header';
			$sticky_menu_section = 'generate_layout_navigation';
		} else {
			$panel = 'generate_menu_plus';
			$navigation_section = 'menu_plus_section';
			$header_section = 'menu_plus_mobile_header';
			$sticky_menu_section = 'menu_plus_sticky_menu';
		}

		// Add Menu Plus section
		// This section shouldn't display anymore for the above reasons
		$wp_customize->add_section(
			'menu_plus_section',
			array(
				'title' => esc_html__( 'General Settings', 'gp-premium' ),
				'capability' => 'edit_theme_options',
				'panel' => 'generate_menu_plus'
			)
		);

		// Mobile menu label
		$wp_customize->add_setting(
			'generate_menu_plus_settings[mobile_menu_label]',
			array(
				'default' => $defaults['mobile_menu_label'],
				'type' => 'option',
				'sanitize_callback' => 'wp_kses_post'
			)
		);

		$wp_customize->add_control(
			'mobile_menu_label_control', array(
				'label' => esc_html__( 'Mobile Menu Label', 'gp-premium' ),
				'section' => $navigation_section,
				'settings' => 'generate_menu_plus_settings[mobile_menu_label]'
			)
		);

		// Sticky menu section
		$wp_customize->add_section(
			'menu_plus_sticky_menu',
			array(
				'title' => esc_html__( 'Sticky Navigation', 'gp-premium' ),
				'capability' => 'edit_theme_options',
				'panel' => $panel,
				'priority' => 33
			)
		);

		// Sticky menu
		$wp_customize->add_setting(
			'generate_menu_plus_settings[sticky_menu]',
			array(
				'default' => $defaults['sticky_menu'],
				'type' => 'option',
				'sanitize_callback' => 'generate_premium_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'generate_menu_plus_settings[sticky_menu]',
			array(
				'type' => 'select',
				'label' => esc_html__( 'Sticky Navigation', 'gp-premium' ),
				'section' => 'menu_plus_sticky_menu',
				'choices' => array(
					'mobile' => esc_html__( 'Mobile only', 'gp-premium' ),
					'desktop' => esc_html__( 'Desktop only', 'gp-premium' ),
					'true' => esc_html__( 'On', 'gp-premium' ),
					'false' => esc_html__( 'Off', 'gp-premium' )
				),
				'settings' => 'generate_menu_plus_settings[sticky_menu]',
				'priority' => 105
			)
		);

		// Transition
		$wp_customize->add_setting(
			'generate_menu_plus_settings[sticky_menu_effect]',
			array(
				'default' => $defaults['sticky_menu_effect'],
				'type' => 'option',
				'sanitize_callback' => 'generate_premium_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'generate_menu_plus_settings[sticky_menu_effect]',
			array(
				'type' => 'select',
				'label' => esc_html__( 'Transition', 'gp-premium' ),
				'section' => 'menu_plus_sticky_menu',
				'choices' => array(
					'fade' => esc_html__( 'Fade', 'gp-premium' ),
					'slide' => esc_html__( 'Slide', 'gp-premium' ),
					'none' => esc_html__( 'None', 'gp-premium' )
				),
				'settings' => 'generate_menu_plus_settings[sticky_menu_effect]',
				'active_callback' => 'generate_sticky_navigation_activated',
				'priority' => 110
			)
		);

		// Auto hide on scroll down
		$wp_customize->add_setting(
			'generate_menu_plus_settings[auto_hide_sticky]',
			array(
				'default' => $defaults['auto_hide_sticky'],
				'type' => 'option',
				'sanitize_callback' => 'generate_premium_sanitize_checkbox'
			)
		);

		$wp_customize->add_control(
			'generate_menu_plus_settings[auto_hide_sticky]',
			array(
				'type' => 'checkbox',
				'label' => esc_html__( 'Hide when scrolling down', 'gp-premium' ),
				'section' => 'menu_plus_sticky_menu',
				'settings' => 'generate_menu_plus_settings[auto_hide_sticky]',
				'priority' => 120,
				'active_callback' => 'generate_sticky_navigation_activated',
			)
		);

		// Navigation logo
		$wp_customize->add_setting(
			'generate_menu_plus_settings[sticky_menu_logo]',
			array(
				'default' => $defaults['sticky_menu_logo'],
				'type' => 'option',
				'sanitize_callback' => 'esc_url_raw'
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'generate_menu_plus_settings[sticky_menu_logo]',
				array(
					'label' => esc_html__( 'Navigation Logo', 'gp-premium' ),
					'section' => $sticky_menu_section,
					'settings' => 'generate_menu_plus_settings[sticky_menu_logo]',
					'priority' => 115
				)
			)
		);

		// Logo placement
		$wp_customize->add_setting(
			'generate_menu_plus_settings[sticky_menu_logo_position]',
			array(
				'default' => $defaults['sticky_menu_logo_position'],
				'type' => 'option',
				'sanitize_callback' => 'generate_premium_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'generate_menu_plus_settings[sticky_menu_logo_position]',
			array(
				'type' => 'select',
				'label' => esc_html__( 'Navigation Logo Placement', 'gp-premium' ),
				'section' => $sticky_menu_section,
				'choices' => array(
					'sticky-menu' => esc_html__( 'Sticky', 'gp-premium' ),
					'menu' => esc_html__( 'Sticky + Static', 'gp-premium' ),
					'regular-menu' => esc_html__( 'Static', 'gp-premium' )
				),
				'settings' => 'generate_menu_plus_settings[sticky_menu_logo_position]',
				'priority' => 120,
				'active_callback' => 'generate_navigation_logo_activated',
			)
		);

		// Mobile Header section
		// No longer displays
		$wp_customize->add_section(
			'menu_plus_mobile_header',
			array(
				'title' => esc_html__( 'Mobile Header', 'gp-premium' ),
				'capability' => 'edit_theme_options',
				'panel' => $panel,
				'priority' => 11
			)
		);

		// Mobile header
		$wp_customize->add_setting(
			'generate_menu_plus_settings[mobile_header]',
			array(
				'default' => $defaults['mobile_header'],
				'type' => 'option',
				'sanitize_callback' => 'generate_premium_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'generate_menu_plus_settings[mobile_header]',
			array(
				'type' => 'select',
				'label' => esc_html__( 'Mobile Header', 'gp-premium' ),
				'section' => $header_section,
				'choices' => array(
					'disable' => esc_html__( 'Off', 'gp-premium' ),
					'enable' => esc_html__( 'On', 'gp-premium' )
				),
				'settings' => 'generate_menu_plus_settings[mobile_header]',
			)
		);

		// Mobile header logo
		$wp_customize->add_setting(
			'generate_menu_plus_settings[mobile_header_logo]',
			array(
				'default' => $defaults['mobile_header_logo'],
				'type' => 'option',
				'sanitize_callback' => 'esc_url_raw'
			)
		);

		$wp_customize->add_control(
			new WP_Customize_Image_Control(
				$wp_customize,
				'generate_menu_plus_settings[mobile_header_logo]',
				array(
					'label' => esc_html__( 'Logo', 'gp-premium' ),
					'section' => $header_section,
					'settings' => 'generate_menu_plus_settings[mobile_header_logo]',
					'active_callback' => 'generate_mobile_header_activated'
				)
			)
		);

		// Sticky mobile header
		$wp_customize->add_setting(
			'generate_menu_plus_settings[mobile_header_sticky]',
			array(
				'default' => $defaults['mobile_header_sticky'],
				'type' => 'option',
				'sanitize_callback' => 'generate_premium_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'generate_menu_plus_settings[mobile_header_sticky]',
			array(
				'type' => 'select',
				'label' => esc_html__( 'Sticky', 'gp-premium' ),
				'section' => $header_section,
				'choices' => array(
					'enable' => esc_html__( 'On', 'gp-premium' ),
					'disable' => esc_html__( 'Off', 'gp-premium' )
				),
				'settings' => 'generate_menu_plus_settings[mobile_header_sticky]',
				'active_callback' => 'generate_mobile_header_activated'
			)
		);

		// Auto hide on scroll down
		$wp_customize->add_setting(
			'generate_menu_plus_settings[mobile_header_auto_hide_sticky]',
			array(
				'default' => $defaults['mobile_header_auto_hide_sticky'],
				'type' => 'option',
				'sanitize_callback' => 'generate_premium_sanitize_checkbox'
			)
		);

		$wp_customize->add_control(
			'generate_menu_plus_settings[mobile_header_auto_hide_sticky]',
			array(
				'type' => 'checkbox',
				'label' => esc_html__( 'Hide when scrolling down', 'gp-premium' ),
				'section' => $header_section,
				'settings' => 'generate_menu_plus_settings[mobile_header_auto_hide_sticky]',
				'active_callback' => 'generate_mobile_header_sticky_activated'
			)
		);

		// Slide-out menu section
		$wp_customize->add_section(
			'menu_plus_slideout_menu',
			array(
				'title' => esc_html__( 'Slideout Navigation', 'gp-premium' ),
				'capability' => 'edit_theme_options',
				'panel' => $panel,
				'priority' => 34
			)
		);

		// Slide-out menu
		$wp_customize->add_setting(
			'generate_menu_plus_settings[slideout_menu]',
			array(
				'default' => $defaults['slideout_menu'],
				'type' => 'option',
				'sanitize_callback' => 'generate_premium_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'generate_menu_plus_settings[slideout_menu]',
			array(
				'type' => 'select',
				'label' => esc_html__( 'Slideout Navigation', 'gp-premium' ),
				'section' => 'menu_plus_slideout_menu',
				'choices' => array(
					'mobile' => esc_html__( 'Mobile only', 'gp-premium' ),
					'desktop' => esc_html__( 'Desktop only', 'gp-premium' ),
					'both' => esc_html__( 'On', 'gp-premium' ),
					'false' => esc_html__( 'Off', 'gp-premium' )
				),
				'settings' => 'generate_menu_plus_settings[slideout_menu]',
			)
		);

		$wp_customize->add_setting(
			'generate_menu_plus_settings[slideout_menu_side]',
			array(
				'default' => $defaults['slideout_menu_side'],
				'type' => 'option',
				'sanitize_callback' => 'generate_premium_sanitize_choices'
			)
		);

		$wp_customize->add_control(
			'generate_menu_plus_settings[slideout_menu_side]',
			array(
				'type' => 'select',
				'label' => esc_html__( 'Side', 'gp-premium' ),
				'section' => 'menu_plus_slideout_menu',
				'choices' => array(
					'left' => esc_html__( 'Left', 'gp-premium' ),
					'right' => esc_html__( 'Right', 'gp-premium' ),
				),
				'settings' => 'generate_menu_plus_settings[slideout_menu_side]',
				'active_callback' => 'generate_slideout_navigation_activated',
			)
		);
	}
}

if ( ! function_exists( 'generate_menu_plus_enqueue_css' ) ) {
	add_action( 'wp_enqueue_scripts', 'generate_menu_plus_enqueue_css', 100 );
	/**
	 * Enqueue scripts
	 */
	function generate_menu_plus_enqueue_css() {
		$settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		// Add sticky menu script
		if ( 'false' !== $settings['sticky_menu'] ) {
			wp_enqueue_style( 'generate-sticky', plugin_dir_url( __FILE__ ) . "css/sticky{$suffix}.css", array(), GENERATE_MENU_PLUS_VERSION );
		}

		// Add slideout menu script
		if ( 'false' !== $settings['slideout_menu'] ) {
			wp_enqueue_style( 'generate-offside', plugin_dir_url( __FILE__ ) . "css/offside{$suffix}.css", array(), GENERATE_MENU_PLUS_VERSION );
		}

		// Add regular menu logo styling
		if ( '' !== $settings['sticky_menu_logo'] ) {
			wp_enqueue_style( 'generate-menu-logo', plugin_dir_url( __FILE__ ) . "css/menu-logo{$suffix}.css", array(), GENERATE_MENU_PLUS_VERSION );
		}

		// Add mobile header CSS
		if ( 'enable' == $settings['mobile_header'] ) {
			wp_enqueue_style( 'generate-mobile-header', plugin_dir_url( __FILE__ ) . "css/mobile-header{$suffix}.css", array(), GENERATE_MENU_PLUS_VERSION );
		}

		// Add inline CSS
		wp_add_inline_style( 'generate-style', generate_menu_plus_inline_css() );

	}
}

if ( ! function_exists( 'generate_menu_plus_enqueue_js' ) ) {
	add_action( 'wp_enqueue_scripts', 'generate_menu_plus_enqueue_js', 0 );
	/**
	 * Enqueue scripts
	 */
	function generate_menu_plus_enqueue_js() {
		$settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		$suffix = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';

		// Add sticky menu script
		if ( ( 'false' !== $settings['sticky_menu'] ) || ( 'enable' == $settings['mobile_header'] && 'enable' == $settings['mobile_header_sticky'] ) ) {
			wp_enqueue_script( 'generate-sticky', plugin_dir_url( __FILE__ ) . "js/sticky{$suffix}.js", array( 'jquery' ), GENERATE_MENU_PLUS_VERSION, true );
		}

		// Add slideout menu script
		if ( 'false' !== $settings['slideout_menu'] ) {
			wp_enqueue_script( 'generate-offside', plugin_dir_url( __FILE__ ) . "js/offside{$suffix}.js", array(), GENERATE_MENU_PLUS_VERSION, true );

			wp_localize_script(
				'generate-offside',
				'offSide',
				array(
					'side' => $settings['slideout_menu_side']
				)
			);
		}
	}
}

if ( ! function_exists( 'generate_menu_plus_mobile_header_js' ) ) {
	add_action( 'wp_enqueue_scripts', 'generate_menu_plus_mobile_header_js', 15 );
	/**
	 * Enqueue scripts
	 */
	function generate_menu_plus_mobile_header_js() {
		if ( function_exists( 'wp_add_inline_script' ) ) {

			$settings = wp_parse_args(
				get_option( 'generate_menu_plus_settings', array() ),
				generate_menu_plus_get_defaults()
			);

			if ( 'enable' == $settings[ 'mobile_header' ] && ( 'desktop' == $settings[ 'slideout_menu' ] || 'false' == $settings[ 'slideout_menu' ] ) ) {
				wp_add_inline_script( 'generate-navigation',
					"jQuery( document ).ready( function($) {
						$( '#mobile-header .menu-toggle' ).on( 'click', function( e ) {
							e.preventDefault();
							$( this ).closest( '#mobile-header' ).toggleClass( 'toggled' );
							$( this ).closest( '#mobile-header' ).attr( 'aria-expanded', $( this ).closest( '#mobile-header' ).attr( 'aria-expanded' ) === 'true' ? 'false' : 'true' );
							$( this ).toggleClass( 'toggled' );
							$( this ).children( 'i' ).toggleClass( 'fa-bars' ).toggleClass( 'fa-close' );
							$( this ).attr( 'aria-expanded', $( this ).attr( 'aria-expanded' ) === 'false' ? 'true' : 'false' );
						});
					});"
				);
			}
		}
	}
}

if ( ! function_exists( 'generate_menu_plus_inline_css' ) ) {
	/**
	 * Enqueue inline CSS
	 */
	function generate_menu_plus_inline_css() {
		// Bail if GP isn't active
		if ( ! function_exists( 'generate_get_defaults' ) ) {
			return;
		}

		$generate_settings = wp_parse_args(
			get_option( 'generate_settings', array() ),
			generate_get_defaults()
		);

		$generate_menu_plus_settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		if ( function_exists( 'generate_spacing_get_defaults' ) ) {
			$spacing_settings = wp_parse_args(
				get_option( 'generate_spacing_settings', array() ),
				generate_spacing_get_defaults()
			);
			$menu_height = $spacing_settings['menu_item_height'];
		} else {
			$menu_height = 60;
		}

		$return = '';

		if ( '' !== $generate_menu_plus_settings['sticky_menu_logo'] ) {
			$return .= '.main-navigation .navigation-logo img {height:' . absint( $menu_height ) . 'px;}';
			$return .= '@media (max-width: ' . ( absint( $generate_settings['container_width'] + 10 ) ) . 'px) {.main-navigation .navigation-logo.site-logo {margin-left:0;}body.sticky-menu-logo.nav-float-left .main-navigation .site-logo.navigation-logo {margin-right:0;}}';
		}

		if ( '' !== $generate_menu_plus_settings['mobile_header_logo'] ) {
			$return .= '.mobile-header-navigation .mobile-header-logo img {height:' . absint( $menu_height ) . 'px;}';
		}

		if ( 'false' !== $generate_menu_plus_settings['sticky_menu'] ) {
			$return .= '.main-navigation .main-nav ul li a,.menu-toggle,.main-navigation .mobile-bar-items a{transition: line-height 300ms ease}';
		}

		return $return;
	}
}

if ( ! function_exists( 'generate_menu_plus_mobile_header' ) ) {
	add_action( 'generate_after_header', 'generate_menu_plus_mobile_header', 5 );
	add_action( 'generate_inside_mobile_header', 'generate_navigation_search', 1 );
	add_action( 'generate_inside_mobile_header', 'generate_mobile_menu_search_icon' );
	function generate_menu_plus_mobile_header() {
		$settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		if ( 'disable' == $settings[ 'mobile_header' ] ) {
			return;
		}

		if ( 'false' !== $settings['mobile_header_auto_hide_sticky'] && $settings[ 'mobile_header_auto_hide_sticky' ] ) {
			$hide_sticky = ' data-auto-hide-sticky="true"';
		} else {
			$hide_sticky = '';
		}
		?>
		<nav itemtype="http://schema.org/SiteNavigationElement" itemscope="itemscope" id="mobile-header"<?php echo $hide_sticky;?> class="main-navigation mobile-header-navigation">
			<div class="inside-navigation grid-container grid-parent">
				<?php do_action( 'generate_inside_mobile_header' ); ?>
				<button class="menu-toggle" aria-controls="mobile-menu" aria-expanded="false">
					<?php do_action( 'generate_inside_mobile_header_menu' ); ?>
					<span class="mobile-menu"><?php echo apply_filters('generate_mobile_menu_label', __( 'Menu', 'generatepress' ) ); ?></span>
				</button>
				<?php
				wp_nav_menu(
					array(
						'theme_location' => apply_filters( 'generate_mobile_header_theme_location', 'primary' ),
						'container' => 'div',
						'container_class' => 'main-nav',
						'container_id' => 'mobile-menu',
						'menu_class' => '',
						'fallback_cb' => 'generate_menu_fallback',
						'items_wrap' => '<ul id="%1$s" class="%2$s ' . join( ' ', generate_get_menu_class() ) . '">%3$s</ul>'
					)
				);
				?>
			</div><!-- .inside-navigation -->
		</nav><!-- #site-navigation -->
		<?php
	}
}

if ( ! function_exists( 'generate_slideout_navigation' ) ) {
	/**
	 * Build the navigation.
	 *
	 * @since 0.1
	 */
	add_action( 'wp_footer', 'generate_slideout_navigation', 0 );
	function generate_slideout_navigation() {
		$settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		if ( 'false' == $settings['slideout_menu'] ) {
			return;
		}
		?>
		<nav itemtype="http://schema.org/SiteNavigationElement" itemscope="itemscope" id="generate-slideout-menu" class="main-navigation slideout-navigation" style="display: none;">
			<div class="inside-navigation grid-container grid-parent">
				<?php
				do_action( 'generate_inside_slideout_navigation' );

				wp_nav_menu(
					array(
						'theme_location' => 'slideout',
						'container' => 'div',
						'container_class' => 'main-nav',
						'menu_class' => '',
						'fallback_cb' => false,
						'items_wrap' => '<ul id="%1$s" class="%2$s slideout-menu">%3$s</ul>'
					)
				);

				do_action( 'generate_after_slideout_navigation' );
				?>
			</div><!-- .inside-navigation -->
		</nav><!-- #site-navigation -->

		<div class="slideout-overlay">
			<button class="slideout-exit">
				<span class="screen-reader-text"><?php esc_attr_e( 'Close', 'gp-premium' ); ?></span>
			</button>
		</div>
		<?php
	}
}

add_action( 'generate_after_slideout_navigation', 'generate_slideout_menu_widget' );
function generate_slideout_menu_widget() {
	if ( is_active_sidebar( 'slide-out-widget' ) ) {
		dynamic_sidebar( 'slide-out-widget' );
	}
}

if ( ! function_exists( 'generate_slideout_menu_fallback' ) ) {
	/**
	 * Menu fallback.
	 *
	 * @param  array $args
	 * @return string
	 * @since 1.1.4
	 */
	function generate_slideout_menu_fallback( $args ) {

	}
}

add_action( 'widgets_init', 'generate_slideout_navigation_widget', 99 );
/**
 * Register widgetized area and update sidebar with default widgets
 */
function generate_slideout_navigation_widget() {
	register_sidebar( array(
		'name'          => esc_html__( 'Slideout Navigation', 'gp-premium' ),
		'id'            => 'slide-out-widget',
		'before_widget' => '<aside id="%1$s" class="slideout-widget">',
		'after_widget'  => '</aside>',
		'before_title'  => apply_filters( 'generate_start_widget_title', '<h2 class="widget-title">' ),
		'after_title'   => apply_filters( 'generate_end_widget_title', '</h2>' ),
	) );
}

if ( ! function_exists( 'generate_slideout_body_classes' ) ) {
	add_filter( 'body_class', 'generate_slideout_body_classes' );
	/**
	 * Adds custom classes to body
	 *
	 * @since 0.1
	 */
	function generate_slideout_body_classes( $classes ) {
		$settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		// Slide-out menu classes
		if ( 'false' !== $settings['slideout_menu'] ) {
			$classes[] = 'slideout-enabled';
		}

		if ( 'mobile' == $settings['slideout_menu'] ) {
			$classes[] = 'slideout-mobile';
		}

		if ( 'desktop' == $settings['slideout_menu'] ) {
			$classes[] = 'slideout-desktop';
		}

		if ( 'both' == $settings['slideout_menu'] ) {
			$classes[] = 'slideout-both';
		}

		// Sticky menu transition class
		if ( 'slide' == $settings['sticky_menu_effect'] ) {
			$classes[] = 'sticky-menu-slide';
		}

		if ( 'fade' == $settings['sticky_menu_effect'] ) {
			$classes[] = 'sticky-menu-fade';
		}

		if ( 'none' == $settings['sticky_menu_effect'] ) {
			$classes[] = 'sticky-menu-no-transition';
		}

		// If sticky menu is enabled
		if ( 'false' !== $settings['sticky_menu'] ) {
			$classes[] = 'sticky-enabled';
		}

		// Sticky menu classes
		if ( '' !== $settings['sticky_menu_logo'] ) {

			if ( 'sticky-menu' == $settings['sticky_menu_logo_position'] ) {
				$classes[] = 'sticky-menu-logo';
			} elseif ( 'menu' == $settings['sticky_menu_logo_position'] ) {
				$classes[] = 'menu-logo';
			} elseif ( 'regular-menu' == $settings['sticky_menu_logo_position'] ) {
				$classes[] = 'regular-menu-logo';
			}

			$classes[] = 'menu-logo-enabled';

		}

		// Menu logo classes
		if ( 'mobile' == $settings['sticky_menu'] ) {
			$classes[] = 'mobile-sticky-menu';
		}

		if ( 'desktop' == $settings['sticky_menu'] ) {
			$classes[] = 'desktop-sticky-menu';
		}

		if ( 'true' == $settings['sticky_menu'] ) {
			$classes[] = 'both-sticky-menu';
		}

		// Mobile header classes
		if ( 'enable' == $settings['mobile_header'] ) {
			$classes[] = 'mobile-header';
		}

		if ( '' !== $settings['mobile_header_logo'] && 'enable' == $settings['mobile_header'] ) {
			$classes[] = 'mobile-header-logo';
		}

		if ( 'enable' == $settings['mobile_header_sticky'] && 'enable' == $settings['mobile_header'] ) {
			$classes[] = 'mobile-header-sticky';
		}

		return $classes;

	}
}

if ( ! function_exists( 'generate_menu_plus_slidebar_icon' ) ) {
	add_filter( 'wp_nav_menu_items', 'generate_menu_plus_slidebar_icon', 10, 2 );
	/**
	 * Add slidebar icon to primary menu if set
	 *
	 * @since 0.1
	 */
	function generate_menu_plus_slidebar_icon( $nav, $args ) {
		$settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		// If the search icon isn't enabled, return the regular nav
		if ( 'desktop' !== $settings['slideout_menu'] && 'both' !== $settings['slideout_menu'] ) {
			return $nav;
		}

		// If our primary menu is set, add the search icon
	    if( $args->theme_location == 'primary' ) {
	        return $nav . '<li class="slideout-toggle"><a href="#generate-slideout-menu" data-transition="overlay"></a></li>';
		}

		// Our primary menu isn't set, return the regular nav
		// In this case, the search icon is added to the generate_menu_fallback() function in navigation.php
	    return $nav;
	}
}

if ( ! function_exists( 'generate_sticky_navigation_classes' ) ) {
	add_filter( 'generate_navigation_class', 'generate_sticky_navigation_classes' );
	/**
	 * Adds custom classes to the navigation.
	 *
	 * @since 0.1
	 */
	function generate_sticky_navigation_classes( $classes ) {

		$settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		if ( 'false' !== $settings['sticky_menu'] && $settings[ 'auto_hide_sticky' ] ) {
			$classes[] = 'auto-hide-sticky';
		}

		return $classes;

	}
}

if ( ! function_exists( 'generate_menu_plus_label' ) ) {
	add_filter( 'generate_mobile_menu_label', 'generate_menu_plus_label' );
	/**
	 * Add mobile menu label
	 *
	 * @since 0.1
	 */
	function generate_menu_plus_label() {
		$settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		return wp_kses_post( $settings['mobile_menu_label'] );
	}
}

if ( ! function_exists( 'generate_menu_plus_sticky_logo' ) ) {
	add_action( 'generate_inside_navigation', 'generate_menu_plus_sticky_logo' );
	/**
	 * Add logo to sticky menu
	 *
	 * @since 0.1
	 */
	function generate_menu_plus_sticky_logo() {
		$settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		if ( '' == $settings['sticky_menu_logo'] ) {
			return;
		}

		echo apply_filters( 'generate_navigation_logo_output', sprintf(
			'<div class="site-logo sticky-logo navigation-logo">
				<a href="%1$s" title="%2$s" rel="home">
					<img class="header-image" src="%3$s" alt="%4$s" />
				</a>
			</div>',
			esc_url( apply_filters( 'generate_logo_href' , home_url( '/' ) ) ),
			esc_attr( apply_filters( 'generate_logo_title', get_bloginfo( 'name', 'display' ) ) ),
			esc_url( apply_filters( 'generate_navigation_logo', $settings['sticky_menu_logo'] ) ),
			esc_attr( apply_filters( 'generate_logo_title', get_bloginfo( 'name', 'display' ) ) )
		) );
	}
}

if ( ! function_exists( 'generate_menu_plus_mobile_header_logo' ) ) {
	add_action( 'generate_inside_mobile_header', 'generate_menu_plus_mobile_header_logo', 5 );
	/**
	 * Add logo to mobile header
	 *
	 * @since 0.1
	 */
	function generate_menu_plus_mobile_header_logo() {
		$settings = wp_parse_args(
			get_option( 'generate_menu_plus_settings', array() ),
			generate_menu_plus_get_defaults()
		);

		if ( '' == $settings['mobile_header_logo'] ) {
			return;
		}

		echo apply_filters( 'generate_mobile_header_logo_output', sprintf(
			'<div class="site-logo mobile-header-logo">
				<a href="%1$s" title="%2$s" rel="home">
					<img class="header-image" src="%3$s" alt="%4$s" />
				</a>
			</div>',
			esc_url( apply_filters( 'generate_logo_href' , home_url( '/' ) ) ),
			esc_attr( apply_filters( 'generate_logo_title', get_bloginfo( 'name', 'display' ) ) ),
			esc_url( apply_filters( 'generate_mobile_header_logo', $settings['mobile_header_logo'] ) ),
			esc_attr( apply_filters( 'generate_logo_title', get_bloginfo( 'name', 'display' ) ) )
		) );
	}
}

/**
 * Build our dynamic CSS.
 *
 * @since 1.6
 */
function generate_menu_plus_make_css() {
	if ( ! function_exists( 'generate_get_color_defaults' ) || ! function_exists( 'generate_get_defaults' ) || ! function_exists( 'generate_get_default_fonts' ) ) {
		return;
	}

	$defaults = array_merge( generate_get_color_defaults(), generate_get_defaults(), generate_get_default_fonts() );

	// Get our color settings
	$settings = wp_parse_args(
		get_option( 'generate_settings', array() ),
		$defaults
	);

	// Initiate our CSS class
	require_once GP_LIBRARY_DIRECTORY . 'class-make-css.php';
	$css = new GeneratePress_Pro_CSS;

	// Navigation background
	$css->set_selector( '.slideout-navigation.main-navigation' );
	$css->add_property( 'background-color', esc_attr( $settings[ 'slideout_background_color' ] ) );

	// Navigation text
	$css->set_selector( '.slideout-navigation.main-navigation .main-nav ul li a' );
	$css->add_property( 'color', esc_attr( $settings[ 'slideout_text_color' ] ) );
	$css->add_property( 'font-weight', esc_attr( $settings[ 'slideout_font_weight' ] ) );
	$css->add_property( 'text-transform', esc_attr( $settings[ 'slideout_font_transform' ] ) );

	if ( '' !== $settings[ 'slideout_font_size' ] ) {
		$css->add_property( 'font-size', absint( $settings[ 'slideout_font_size' ] ), false, 'px' );
	}

	// Slideout link color
	$css->set_selector( '.slideout-navigation a' );
	$css->add_property( 'color', esc_attr( $settings[ 'slideout_text_color' ] ) );

	// Sub-navigation background
	$css->set_selector( '.slideout-navigation.main-navigation ul ul' );
	$css->add_property( 'background-color', esc_attr( $settings[ 'slideout_submenu_background_color' ] ) );

	// Sub-navigation text
	$css->set_selector( '.slideout-navigation.main-navigation .main-nav ul ul li a' );
	$css->add_property( 'color', esc_attr( $settings[ 'slideout_submenu_text_color' ] ) );

	if ( '' !== $settings[ 'slideout_font_size' ] ) {
		$css->add_property( 'font-size', absint( $settings[ 'slideout_font_size' ] - 1 ), false, 'px' );
	}

	if ( '' !== $settings[ 'slideout_mobile_font_size' ] ) {
		$css->start_media_query( apply_filters( 'generate_mobile_media_query', '(max-width:768px)' ) );
			$css->set_selector( '.slideout-navigation.main-navigation .main-nav ul li a' );
			$css->add_property( 'font-size', absint( $settings[ 'slideout_mobile_font_size' ] ), false, 'px' );

			$css->set_selector( '.slideout-navigation.main-navigation .main-nav ul ul li a' );
			$css->add_property( 'font-size', absint( $settings[ 'slideout_mobile_font_size' ] - 1 ), false, 'px' );
		$css->stop_media_query();
	}

	// Navigation background/text on hover
	$css->set_selector( '.slideout-navigation.main-navigation .main-nav ul li:hover > a,.slideout-navigation.main-navigation .main-nav ul li:focus > a,.slideout-navigation.main-navigation .main-nav ul li.sfHover > a' );
	$css->add_property( 'color', esc_attr( $settings[ 'slideout_text_hover_color' ] ) );
	$css->add_property( 'background-color', esc_attr( $settings[ 'slideout_background_hover_color' ] ) );

	// Sub-Navigation background/text on hover
	$css->set_selector( '.slideout-navigation.main-navigation .main-nav ul ul li:hover > a,.slideout-navigation.main-navigation .main-nav ul ul li:focus > a,.slideout-navigation.main-navigation .main-nav ul ul li.sfHover > a' );
	$css->add_property( 'color', esc_attr( $settings[ 'slideout_submenu_text_hover_color' ] ) );
	$css->add_property( 'background-color', esc_attr( $settings[ 'slideout_submenu_background_hover_color' ] ) );

	// Navigation background / text current + hover
	$css->set_selector( '.slideout-navigation.main-navigation .main-nav ul li[class*="current-menu-"] > a, .slideout-navigation.main-navigation .main-nav ul li[class*="current-menu-"] > a:hover,.slideout-navigation.main-navigation .main-nav ul li[class*="current-menu-"].sfHover > a' );
	$css->add_property( 'color', esc_attr( $settings[ 'slideout_text_current_color' ] ) );
	$css->add_property( 'background-color', esc_attr( $settings[ 'slideout_background_current_color' ] ) );

	// Sub-Navigation background / text current + hover
	$css->set_selector( '.slideout-navigation.main-navigation .main-nav ul ul li[class*="current-menu-"] > a,.slideout-navigation.main-navigation .main-nav ul ul li[class*="current-menu-"] > a:hover,.slideout-navigation.main-navigation .main-nav ul ul li[class*="current-menu-"].sfHover > a' );
	$css->add_property( 'color', esc_attr( $settings[ 'slideout_submenu_text_current_color' ] ) );
	$css->add_property( 'background-color', esc_attr( $settings[ 'slideout_submenu_background_current_color' ] ) );

	// RTL menu item padding
//	if ( is_rtl() ) {
//		$css->set_selector( '.secondary-navigation .main-nav ul li.menu-item-has-children > a' );
	//	$css->add_property( 'padding-right', absint( $generate_settings[ 'secondary_menu_item' ] ), false, 'px' );
	//}

	return $css->css_output();
}

add_action( 'wp_enqueue_scripts', 'generate_menu_plus_enqueue_dynamic_css', 100 );
/**
 * Enqueue our dynamic CSS.
 *
 * @since 1.6
 */
function generate_menu_plus_enqueue_dynamic_css() {
	wp_add_inline_style( 'generate-style', generate_menu_plus_make_css() );
}
