<?php

namespace TmdHelper\App\Api\Media;

use WP_REST_Request;
use WP_Rewrite;

class MediaManager
{
    public function saveImageIntoMediaByUrl(string $url)
    {
        if (!self::isWorkingUrl($url)) {
            throw new \Exception('Image URL is not correct');
        }
        require_once(ABSPATH . "wp-includes/pluggable.php");
        require_once(ABSPATH . 'wp-admin/includes/image.php');
        require_once(ABSPATH . 'wp-admin/includes/file.php');
        require_once ABSPATH . 'wp-admin/includes/media.php';
        $GLOBALS['wp_rewrite'] = new WP_Rewrite();

        // load file into site
        $tmp = download_url($url);
        $file_array = [
            'name' => basename($url),
            'tmp_name' => $tmp
        ];
        $id = media_handle_sideload($file_array, 0);
        // remove file
        @unlink($tmp);

        return $this->getMediaByIdRest($id);
    }

    /**
     * Check if URL is working
     * @param string $url
     * @return bool
     */
    public static function isWorkingUrl(string $url)
    {
        $isWorks = true;
        $headers = @get_headers($url);
        if (!$headers || preg_match('/HTTP\/1.1 404/', $headers[0])) {
            $isWorks = false;
        }

        return $isWorks;
    }

    /**
     * @param string $url
     * @return mixed
     */
    public function getFileMetaDataByUrl(string $url)
    {
        $file = fopen($url, 'rb');
        $wrapperData = stream_get_meta_data($file)['wrapper_data'];
        fclose($file);

        return $wrapperData;
    }

    public function getMediaByIdRest(int $mediaId)
    {
        $route = "/wp/v2/media/{$mediaId}";
        $method = 'GET';
        $request = new WP_REST_Request($method, $route);
        $response = rest_do_request($request);

        return $response;
    }
}
