<?php

namespace TmdHelper\App\Api\Settings;

/**
 * Class SettingsManager
 * Performs changes wp settings in wp_options table
 */
class SettingsManager
{
    const AVAILABLE_SETTINGS = [
        'blog_public',
        'page_for_posts',
        'page_on_front',
        'siteurl',
        'home',
    ];
    /**
     * @var Reference/wpdb
     */
    private $wpdb;

    /**
     * settings
     * @var array
     */
    protected $settings;

    /**
     * Matomo_Configurator constructor.
     *
     * @param Reference/wpdb $wbdbInstance
     */
    public function __construct($wbdbInstance)
    {
        $this->wpdb = $wbdbInstance;
    }

    /**
     * Performs inserting and updating db
     * @return array
     */
    public function run()
    {
        return $this->updateConfiguration();
    }

    /**
     * updates configuration in DB
     */
    public function updateConfiguration()
    {
        foreach ($this->settings as $optionName => $optionValue){
            $this->wpdb->update(
                $this->wpdb->options,
                [
                    'option_name'  => $optionName,
                    'option_value' => $optionValue,
                ],
                ['option_name' => $optionName],
                [
                    '%s',
                    '%s'
                ],
                ['%s']
            );
        }

        return $this->settings;
    }

    /**
     * @param array $settings
     */
    public function setSettings(array $settings)
    {
        $this->settings = $this->getAvailableSettings($settings);
    }

    /**
     * @return array
     */
    public function getSettings()
    {
        return $this->settings;
    }

    /**
     * Select available settings from DB
     */
    public function selectSettings()
    {
        $query = sprintf(
            "SELECT `option_name`, `option_value` FROM %s WHERE `option_name` IN ('%s')",
            $this->wpdb->options,
            implode("','", self::AVAILABLE_SETTINGS)
        );
        $results = $this->wpdb->get_results($query, ARRAY_A);
        $formattedResult = [];
        foreach ($results as $setting){
            $formattedResult[$setting['option_name']] = $setting['option_value'];
        }
        $this->setSettings($formattedResult);
    }

    /**
     * @param array $settings
     *
     * @return array
     */
    protected function getAvailableSettings(array $settings)
    {
        $availableSettings = [];
        foreach (self::AVAILABLE_SETTINGS as $availableOption){
            if(!array_key_exists($availableOption, $settings)){
                continue;
            }
            $availableSettings[$availableOption] = $settings[$availableOption];
        }
        return $availableSettings;
    }
}
