<?php
/**
 * AMP WP Third Party Functions
 *
 * @category    Third_Party
 * @package     Amp_WP/Functions
 * @author      Pixelative <mohsin@pixelative.co>
 * @copyright   Copyright (c) 2019, Pixelative
 */

if ( ! function_exists( 'amp_wp_onesignal_notifications' ) ) {
    
    function amp_wp_onesignal_notifications() {
        
        $amp_wp_third_party_plugins_support_settings = get_option('amp_wp_third_party_plugins_support_settings');
        if(
            !isset( $amp_wp_third_party_plugins_support_settings['onesignal_switch'] ) &&
            empty( $amp_wp_third_party_plugins_support_settings['onesignal_switch'] )
        ) {
            return;
        }
        
        amp_wp_enqueue_script( 'amp-web-push', 'https://cdn.ampproject.org/v0/amp-web-push-0.1.js' );
        amp_wp_enqueue_block_style( 'onesignal-free-web-push-notifications', AMP_WP_TEMPLATE_DIR_CSS . 'themes/'.AMP_WP_THEME_NAME.'/plugins/onesignal-free-web-push-notifications/onesignal-free-web-push-notifications' );
        
        $onesignal_domain = '';
        $onesignal_domain_sw = '';
        $onesignal_subdomain = '';
        $onesignal_app_id = '';
        $helper_iframe_url = '';
        $permission_dialog_url = '';
        $service_worker_url = '';
        
        // HTTPS sites
        $onesignal_domain = AMP_WP_DIR_URL . 'includes/onesignal-integration/';
        $onesignal_domain_sw = trailingslashit( home_url() );
        $onesignal_app_id = $amp_wp_third_party_plugins_support_settings['onesignal_app_id'];
        $helper_iframe_url = $onesignal_domain . 'amp-helper-frame.html?appId=' . $onesignal_app_id;
        $permission_dialog_url = $onesignal_domain . 'amp-permission-dialog.html?appId=' . $onesignal_app_id;
        $service_worker_url = plugins_url('onesignal-free-web-push-notifications/sdk_files/OneSignalSDKWorker.js.php?appId=' . $onesignal_app_id);
        
        // HTTP sites
        if ( isset( $amp_wp_third_party_plugins_support_settings['onesignal_switch_http_site'] ) && "1" == $amp_wp_third_party_plugins_support_settings['onesignal_switch_http_site'] ) {
            $onesignal_subdomain = $amp_wp_third_party_plugins_support_settings['onesignal_http_site_subdomain'];
            if ( $onesignal_subdomain ) {
                $onesignal_subdomain = $onesignal_subdomain . '.';
            }
            $helper_iframe_url = 'https://' . $onesignal_subdomain . 'os.tc/amp/helper_frame?appId=' . $onesignal_app_id . '';
            $permission_dialog_url = 'https://' . $onesignal_subdomain . 'os.tc/amp/permission_dialog?appId=' . $onesignal_app_id . '';
            $service_worker_url = 'https://' . $onesignal_subdomain . 'os.tc/OneSignalSDKWorker.js?appId=' . $onesignal_app_id . '';
        }
        ?>
        <amp-web-push
            id="amp-web-push"
            layout="nodisplay"
            helper-iframe-url="<?php echo esc_url( $helper_iframe_url ); ?>"
            permission-dialog-url="<?php echo esc_url( $permission_dialog_url ); ?>"
            service-worker-url="<?php echo esc_url( $service_worker_url ); ?>">
        </amp-web-push> 
        <?php
    }
}
add_action( 'amp_wp_body_beginning', 'amp_wp_onesignal_notifications', 11 );


if( ! function_exists('amp_wp_onesignal_notifications_widget') ) {
    
	function amp_wp_onesignal_notifications_widget() {
        
        $amp_wp_third_party_plugins_support_settings = get_option('amp_wp_third_party_plugins_support_settings');
        if(
            !isset( $amp_wp_third_party_plugins_support_settings['onesignal_switch'] ) &&
            empty( $amp_wp_third_party_plugins_support_settings['onesignal_switch'] )
        ) {
            return;
        }
        
        ?>
        <!-- Push Notification Widget -->
        <div class="amp-web-push-container">
            
            <!-- A subscription widget -->
            <amp-web-push-widget visibility="unsubscribed" layout="fixed" width="245" height="45">
                <button class="subscribe" on="tap:amp-web-push.subscribe">
                    <i class="fa fa-bell" aria-hidden="true"></i>
                    <?php echo amp_wp_translation_get('onesignal_subscribe'); ?>
                </button>
            </amp-web-push-widget>

            <!-- An unsubscription widget -->
            <amp-web-push-widget visibility="subscribed" layout="fixed" width="230" height="45">
                <button class="unsubscribe" on="tap:amp-web-push.unsubscribe"><?php echo amp_wp_translation_get('onesignal_unsubsribe'); ?></button>
            </amp-web-push-widget>
        </div>
	<?php
	}
}

$amp_wp_third_party_plugins_support_settings = get_option('amp_wp_third_party_plugins_support_settings');
if( "below_the_content" == $amp_wp_third_party_plugins_support_settings['onesignal_position'] ) {
    add_action( 'amp_wp_post_content_below', 'amp_wp_onesignal_notifications_widget' );
} elseif( "above_the_content" == $amp_wp_third_party_plugins_support_settings['onesignal_position'] ) {
    add_action( 'amp_wp_post_content_before', 'amp_wp_onesignal_notifications_widget' );
}