<?php global $veliki_opt;
/**
 * @package Veliki
 */

if(isset( $veliki_opt['blog_sidebar'])) {
   if( $veliki_opt['blog_sidebar'] == 'without_sidebar' ):
        $thumb_size = 'full';
   else:
        $thumb_size = 'veliki_standard_card';
   endif;
}else {
    $thumb_size = 'veliki_standard_card';
}
if( isset( $veliki_opt['enable_lazyloader'] ) ):
    $is_lazyloader = $veliki_opt['enable_lazyloader'];
else:
    $is_lazyloader = true;
endif;

if( $is_lazyloader == true ):
    $lazy_class = 'smartify';
    $lazy_attr = 'sm-';
else:
    $lazy_class = '';
    $lazy_attr = '';
endif;
// Blog Column
$veliki_blog_grid = !empty($veliki_opt['veliki_blog_grid']) ? $veliki_opt['veliki_blog_grid'] : 'col-lg-12 col-md-12';
if ( !empty($_GET['veliki_blog_grid']) ) {
    $veliki_blog_grid = $_GET['veliki_blog_grid'];
}
?>

<div <?php post_class( $veliki_blog_grid ); ?>>
    <div class="single-blog-post">
        <?php if(has_post_thumbnail()) { ?>
            <div class="entry-thumbnail">
                <a href="<?php the_permalink() ?>">
                    <img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php the_post_thumbnail_url( $thumb_size ) ?>" alt="<?php esc_attr__('blog image', 'veliki')?>">
                </a>
            </div>
        <?php } ?>

        <div class="post-content">
            <?php if( isset( $veliki_opt['is_post_meta'] ) && $veliki_opt['is_post_meta'] == true ) { ?>
                <ul class="entry-meta">
                    <li>
                        <a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ) ?>">
                            <?php the_author() ?>
                        </a>
                    </li>
                    <li>
                        <?php echo esc_html(get_the_date('F d, Y')) ?>
                    </li>
                    <li>
                        <?php comments_number(); ?>
                    </li>
                </ul> 
            <?php } ?>
            <h3 class="title"><a href="<?php the_permalink() ?>"><?php the_title() ?></a></h3>

            <?php the_excerpt() ?>
            
            <a href="<?php the_permalink() ?>" class="learn-more-btn">
                <?php if(isset($veliki_opt['post_read_more'] ) && !$veliki_opt['post_read_more'] == ''){ echo esc_html($veliki_opt['post_read_more']); }else{ echo esc_html__('Read More','veliki'); } ?>
                <i class="flaticon-add-1"></i>
            </a>
        </div>
    </div>
</div>
 