<?php global $veliki_opt;
/**
 * Single Resource Page
 * @package Veliki
 */

get_header();

// After Hiding Banner add spacing
if( veliki_hide_page_banner() == 1 ){
    $page_spac = "mt-80";
} else {
    $page_spac = "";
}
// Page Banner Alignment Class Generate
if(veliki_page_banner_alignment() == 1 ){
    $alignment = "text-left";
} elseif(veliki_page_banner_alignment() == 3) {
    $alignment = "text-right";
} else {
	$alignment = "text-center";
}

if ( function_exists('acf_add_options_page') ) {
	$bg = get_field( 'banner_background_image' );
} else {
	$bg = '';
}

if( isset( $veliki_opt['enable_lazyloader'] ) ):
    $is_lazyloader = $veliki_opt['enable_lazyloader'];
else:
    $is_lazyloader = true;
endif;

if( $is_lazyloader == true ):
    $lazy_class = 'smartify';
    $lazy_attr = 'sm-';
else:
    $lazy_class = '';
    $lazy_attr = '';
endif;

// Page Title 
if( isset($veliki_opt['page_title_tag']) ):
    $tag = $veliki_opt['page_title_tag'];
else:
    $tag = 'h2';
endif;

if(veliki_hide_page_banner() == 1 ) {} else { ?>
	<div class="page-title-area" style="background-image:url(<?php echo esc_url( $bg ); ?>);">
		<div class="container">
			<div class="page-title-content <?php echo esc_attr($alignment); ?>">
				<<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>
				<?php
				if(veliki_breadcumb() != 1){
					if ( function_exists('yoast_breadcrumb') ) {
                    	yoast_breadcrumb( '<p class="veliki-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                	} else { ?>
					<ul>
						<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e('Home', 'veliki')?></a></li>
						<li><?php the_title(); ?></li>
					</ul><?php
					}
				} ?>
			</div>
		</div>
		<div class="lines">
			<div class="line"></div>
			<div class="line"></div>
			<div class="line"></div>
		</div>
		<div class="shape3">
			<img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki' ); ?>">
		</div>
	</div>
	<?php
} ?>

<!-- Start Service Details Area -->
<div class="resources-details-area ptb-110 <?php echo esc_attr($page_spac); ?>">
    <div class="container">
        <?php
        while ( have_posts() ) :
        the_post(); ?>

        <?php echo the_content(); ?> 

        <?php
        endwhile; // End of the loop.
        ?>
    </div>
</div>
<!-- End Research Details Area -->

<?php
get_footer();
