<?php global $veliki_opt;
/**
 * The template for displaying all pages
 */

get_header();

/**
 * Page Control
*/

// After Hiding Banner add spacing
if( veliki_hide_page_banner() == 1 || veliki_hide_page_banner_acf() == 'yes' ){
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
}

// Page Banner Alignment Class Generate
if( veliki_page_banner_alignment() == 2 ){
    $alignment = 'text-center';
} elseif(veliki_page_banner_alignment() == 3) {
    $alignment = 'text-right';
} else {
	$alignment = 'text-left';
}

// Page Title 
if( isset($veliki_opt['page_title_tag']) ):
    $tag = $veliki_opt['page_title_tag'];
else:
    $tag = 'h2';
endif;

if( isset( $veliki_opt['enable_lazyloader'] ) ):
    $is_lazyloader = $veliki_opt['enable_lazyloader'];
else:
    $is_lazyloader = true;
endif;

if( $is_lazyloader == true ):
    $lazy_class = 'smartify';
    $lazy_attr = 'sm-';
else:
    $lazy_class = '';
    $lazy_attr = '';
endif;

if( veliki_hide_page_banner() == 1 ){
	if( function_exists('acf_add_options_page') && get_field('page_banner_hide') ) {} 
} 
elseif( veliki_hide_page_banner() != 1 && veliki_hide_page_banner_acf() == 'yes' ){ 
	{} 
} 
else { ?>
	<div class="page-title-area" style="background-image:url(<?php echo esc_url( get_the_post_thumbnail_url() ); ?>);">
		<div class="container">
			<div class="page-title-content <?php echo esc_attr($alignment); ?>">
				<<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>
				<?php
				if(veliki_breadcumb() != 1){
					if ( function_exists('yoast_breadcrumb') ) {
                    	yoast_breadcrumb( '<p class="veliki-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                	} else { ?>
					<ul>
						<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e('Home', 'veliki')?></a></li>
						<li><?php the_title(); ?></li>
					</ul><?php
					}
				} ?>
			</div>
		</div>
		<div class="lines">
			<div class="line"></div>
			<div class="line"></div>
			<div class="line"></div>
		</div>
		<div class="shape3">
			<img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/shape/1.svg' ); ?>" alt="<?php echo esc_attr__( 'Shape', 'veliki' ); ?>">
		</div>
	</div>
<?php } ?>

<?php
//Normal Page Editor
if (!veliki_is_elementor()) { ?>
	<div class="page-main-content">
<?php
} ?>
	<!-- Start About Area -->
	<div class="page-area <?php echo esc_attr($page_spac); ?>">
		<?php if (!veliki_is_elementor()) { ?>
			<div class="container">
		<?php } ?>
				<?php
				while ( have_posts() ) :
					the_post();

					//No Content
					$thecontent = get_the_content();
					if(empty($thecontent)){  ?><div class="veliki-single-blank-page"> </div><?php }

					get_template_part( 'template-parts/content', 'page' );

					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;

				endwhile; // End of the loop.
				?>
		<?php if (!veliki_is_elementor()) { ?>
			</div>
		<?php } ?>
	</div>
<?php
//Normal Page Editor
if (!veliki_is_elementor()) { ?>
</div> <?php } 

get_footer();