<?php 
/**
 * Social Link
 * @package WordPress
 * @subpackage Veliki
*/ 


if ( ! function_exists( 'veliki_social_link' ) ) :
    function veliki_social_link(){ 
        global $veliki_opt;
        if( isset( $veliki_opt['veliki_social_target'] ) ) {
            $target = $veliki_opt['veliki_social_target'];
        }else {
            $target = '_blank';
        }
        ?>
        <ul class="social">
            <?php if (isset($veliki_opt['twitter-url'] ) && $veliki_opt['twitter-url']) { ?>
                <li>
                    <a target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($veliki_opt['twitter-url']);?>" class="twitter" > <i class="flaticon-twitter-black-shape"></i></a>
                </li>
            <?php  } ?>

            <?php if (isset($veliki_opt['facebook-url'] ) && $veliki_opt['facebook-url']) { ?>
                <li>
                    <a target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($veliki_opt['facebook-url']); ?>" class="facebook"> <i class="flaticon-facebook-letter-logo"></i></a>
                </li>
            <?php  } ?>

            <?php if (isset($veliki_opt['instagram-url'] ) && $veliki_opt['instagram-url'] ) { ?>
                <li>
                    <a target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($veliki_opt['instagram-url']); ?>" class="instagram"> <i class="flaticon-instagram-logo"></i></a>
                </li>
            <?php  } ?>

            <?php 
            if (isset($veliki_opt['youtube-url'] ) && $veliki_opt['youtube-url'] ) { ?>
            <li>
                <a target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($veliki_opt['youtube-url']);?>" > <i class="flaticon-youtube"></i></a>
            </li>
            <?php } ?>

            <?php 
            if (isset($veliki_opt['linkedin-url'] ) && $veliki_opt['linkedin-url'] ) { ?>
            <li>
                <a target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($veliki_opt['linkedin-url']);?>" > <i class="fab fa-linkedin"></i></a>
            </li>
            <?php  } ?>

            <?php 
            if (isset($veliki_opt['pinterest-url'] ) && $veliki_opt['pinterest-url'] ) { ?>
            <li>
                <a target="<?php echo esc_attr($target); ?>" href="<?php echo esc_url($veliki_opt['pinterest-url']);?>" > <i class="fab fa-pinterest"></i></a>
            </li>
            <?php  } ?>

            <?php if (isset($veliki_opt['dribbble-url'] ) && $veliki_opt['dribbble-url'] ) { ?>
                <li>
                    <a target="<?php echo esc_attr($target); ?>" href="<?php echo esc_url($veliki_opt['dribbble-url']);?>" > <i class="fab fa-dribbble"></i></a>
                </li>
            <?php } ?>

            <?php if (isset($veliki_opt['tumblr-url'] ) && $veliki_opt['tumblr-url'] ) { ?>
                <li>
                    <a target="<?php echo esc_attr($target); ?>" href="<?php  echo esc_url($veliki_opt['tumblr-url']);?>" > <i class="fab fa-tumblr"></i></a>
                </li>
            <?php } ?>
        </ul>
    <?php
    } 
endif; ?>
