<?php global $veliki_opt;
/**
 * The template for displaying the footer
 * @package Veliki
 */
	// White Logo
	if(isset($veliki_opt['white_logo']['url']) && $veliki_opt['white_logo']['url'] !='' ) {
		$white_logo = $veliki_opt['white_logo']['url'];
	}else {
		$white_logo = "null";
	} 
	// Map Image
	if(isset($veliki_opt['map_img']['url']) && $veliki_opt['map_img']['url'] !='' ) {
		$map_img = $veliki_opt['map_img']['url'];
	}else {
		$map_img = "null";
	}

	// Footer Widget
	if(!is_active_sidebar( 'footer_widgets')) {
		$footer_widget = 'yes';
		$footer_padding = 'footer-top-padding';
		$footer_margin = 'copy-top-margin';
	} else { 
		$footer_padding = '';
		$footer_margin = '';
		$footer_widget = 'no';
	} 
	
	// Footer Class
	$footer_map_none = 'footer-map-none';

	if( isset( $veliki_opt['enable_lazyloader'] ) ):
		$is_lazyloader = $veliki_opt['enable_lazyloader'];
	else:
		$is_lazyloader = true;
	endif;

	if( $is_lazyloader == true ):
		$lazy_class = 'smartify';
		$lazy_attr = 'sm-';
	else:
		$lazy_class = '';
		$lazy_attr = '';
	endif; 
	
	$news_btn_text    = !empty($veliki_opt['news_btn_text']) ? $veliki_opt['news_btn_text'] : '';
	$placeholder_text = !empty($veliki_opt['placeholder_text']) ? $veliki_opt['placeholder_text'] : '';

	// Choose Navbar Style
	if (class_exists('ACF')) {
		if( get_field('choose_footer_style') == 2 ) {
			$footer_style = 2;
		} elseif( get_field('choose_footer_style', get_option('page_for_posts') ) == 2 ) {
			$footer_style = 2;
		}else {
			$footer_style = 1;
		}
	} else {
		$footer_style = 1;
	}

	?>
	<!-- Start Footer Area -->
	<?php if ( !is_404()){ ?>
		<footer class="footer-area <?php echo esc_attr( $footer_padding ); ?>">
			<div class="container">
				<div class="row">
				<?php $footer_column = !empty($veliki_opt['footer_column']) ? $veliki_opt['footer_column'] : '3'; ?>
					<div class="col-lg-<?php echo esc_attr($footer_column); ?> col-md-6 col-sm-6">
						<?php if( $footer_style == 2 ): ?>
							<div class="single-footer-widget">
								<div class="logo">
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
										<?php
										// White Logo
										if ( $white_logo != 'null' ) { ?>
											<img src="<?php echo esc_url($white_logo); ?>" alt="<?php bloginfo( 'title' ); ?>"><?php
										} else { ?>
											<h2><?php bloginfo( 'name' ); ?></h2> <?php  
										} ?>
									</a>
									
									<?php 
									if(isset($veliki_opt['footer-social-text']) && $veliki_opt['footer-social-text'] !='' ) { ?>
										<p> <?php echo esc_html($veliki_opt['footer-social-text']); ?> </p> <?php
									} ?>
								</div>

								<?php if( $news_btn_text != '' ): ?>
									<form class="mailchimp newsletter-form" method="post">
										<input type="email" class="input-newsletter memail" placeholder="<?php echo esc_attr($placeholder_text); ?>" name="EMAIL" required>

										<button type="submit"><?php echo esc_html($news_btn_text); ?></button>
										<div class="mchimp-errmessage alert alert-danger" style="display: none;"></div>
										<div class="mchimp-sucmessage alert alert-primary" style="display: none;"></div>
									</form>
								<?php endif; ?>
							</div>
						<?php else : ?>
							<div class="single-footer-widget">
								<div class="logo">
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
										<?php
										// White Logo
										if ( $white_logo != 'null' ) { ?>
											<img src="<?php echo esc_url($white_logo); ?>" alt="<?php bloginfo( 'title' ); ?>"><?php
										} else { ?>
											<h2><?php bloginfo( 'name' ); ?></h2> <?php  
										} ?>
									</a>
									
									<?php 
									if(isset($veliki_opt['footer-social-text']) && $veliki_opt['footer-social-text'] !='' ) { ?>
										<p> <?php echo esc_html($veliki_opt['footer-social-text']); ?> </p> <?php
									} ?>
								</div>
								<?php veliki_social_link(); ?>
							</div>
						<?php endif; ?>
					</div>

					<?php if ( is_active_sidebar( 'footer_widgets') ) : ?>
						<?php dynamic_sidebar( 'footer_widgets' ); ?>
					<?php endif; ?>
				</div>
			</div> 

			<div class="copyright-area <?php echo esc_attr( $footer_margin ); ?>">
				<div class="container">
					<div class="row align-items-center">
						<div class="col-lg-6 col-md-6 col-sm-6">
							<p>
							<?php if(isset($veliki_opt['footer-copyright-text']) && $veliki_opt['footer-copyright-text'] !='') { 
								echo wp_kses_post($veliki_opt['footer-copyright-text']) ;
							} else {
								echo esc_html__('© Copyright 2020 All Rights Reserved.','veliki') ;
							} ?>
							</p>
						</div>

						<div class="col-lg-6 col-md-6 col-sm-6">
							<?php
							if(has_nav_menu('footer-bottom-menu')){
								wp_nav_menu( array(
									'theme_location'  => 'footer-bottom-menu',
									'depth'           => 1,
									'fallback_cb'     => false,
									'menu_id'         => 'footer-bottom-menu-one',
								) );
							} ?>
						</div>
					</div>
				</div>
			</div>

			<?php if (isset($veliki_opt['show_mapimage']) && $veliki_opt['show_mapimage'] == '1') { 
				if($map_img !='null') { ?>
					<div class="circle-map <?php if( $footer_widget == 'yes' ){ echo esc_attr($footer_map_none); } ?>"><img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url($map_img); ?>" alt="<?php bloginfo( 'name' ); ?>"></div><?php
				}
			} ?>
		</footer>
	<?php } ?>
	<!-- End Footer Area -->

	<div class="go-top"><i class="fas fa-arrow-up"></i><i class="fas fa-arrow-up"></i></div>

	<?php wp_footer(); ?>

	</body>
</html>