<?php global $veliki_opt;
/**
 * The main theme file
 * @package veliki
 */

get_header(); ?>
<?php

// Blog Sidebar
if( isset( $veliki_opt['blog_sidebar']) ) {
    if( $veliki_opt['blog_sidebar'] == 'without_sidebar_center' ):
        $sidebar = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $veliki_opt['blog_sidebar'] == 'without_sidebar' ):
        $sidebar = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'article-sidebar' ) ):
            $sidebar = 'col-lg-8 col-md-12';
        else:
            $sidebar = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide = $veliki_opt['blog_sidebar'];
} else {
    if( is_active_sidebar( 'article-sidebar' ) ):
        $sidebar = 'col-lg-8 col-md-12';
        $sidebar_hide = 'with_sidebar';
    else:
        $sidebar = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide = 'without_sidebar';
    endif;
}

// After Hiding Banner add spacing
if( veliki_hide_page_banner() == 1 ){
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
}

// Page Banner Alignment Class Generate
if( veliki_page_banner_alignment() == 2 ){
    $alignment = 'text-center';
} elseif(veliki_page_banner_alignment() == 3) {
    $alignment = 'text-right';
} else {
	$alignment = 'text-left';
} 

if( isset($veliki_opt['archive_bg']) ) {
    $bg    = $veliki_opt['archive_bg']['url'];
} else {
    $bg    = '';
}

$veliki_blog_layout = !empty($veliki_opt['veliki_blog_layout']) ? $veliki_opt['veliki_blog_layout'] : 'container';
if ( !empty($_GET['veliki_blog_layout']) ) {
    $veliki_blog_layout = $_GET['veliki_blog_layout'];
}

if( isset($veliki_opt['page_title_tag']) ):
    $tag = $veliki_opt['page_title_tag'];
else:
    $tag = 'h2';
endif;

if( veliki_hide_page_banner() == 1 ) { }else { ?>
	<div class="page-title-area" style="background-image:url(<?php echo esc_url($bg); ?>);">
		<div class="container">
			<div class="page-title-content <?php echo esc_attr( $alignment ); ?>">
				<<?php echo esc_attr( $tag ); ?>><?php the_archive_title(); ?></<?php echo esc_attr( $tag ); ?>>
				<?php the_archive_description( '<div class="archive-description">', '</div>' ); ?>
			</div>
		</div>
	</div>
<?php
} ?>

<!-- Start Blog Area -->
<div class="blog-area ptb-110 <?php echo esc_attr($page_spac); ?>">
    <div class="<?php echo esc_attr( $veliki_blog_layout ); ?>">
        <div class="row">
            <!-- Start Blog Content -->
            <div class="<?php echo esc_attr( $sidebar ); ?>">
                <?php
                if ( have_posts() ) :
                    while ( have_posts() ) :
                        the_post();
                        get_template_part( 'template-parts/content',get_post_format());
                    endwhile;
                else :
                    get_template_part( 'template-parts/content', 'none' );
                endif;
                ?>
        
                <!-- Stat Pagination -->
                <div class="pagination-area">
                    <nav aria-label="navigation">
                    <?php echo paginate_links( array(
                        'format' => '?paged=%#%',
                        'prev_text' => '<i class="fa fa-angle-double-left"></i>',
                        'next_text' => '<i class="fa fa-angle-double-right"></i>',
                        )
                    ) ?>
                    </nav>
                </div>
            </div>
            <!-- End Blog Content -->
            <?php if( $sidebar_hide == 'with_sidebar' ): ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>
        </div>   
    </div>
</div>
<!-- End Blog Area -->
<?php
get_footer();
