<?php global $veliki_opt;
/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package Veliki
 */

get_header();

if ( isset($veliki_opt['content_not_found']) ):
	$title = $veliki_opt['content_not_found']; 
	$content = $veliki_opt['long_content_not_found']; 
	$button = $veliki_opt['button_not_found'];
	$image = $veliki_opt['img-404']['url'];
else:
	$title = esc_html__('Page Not Found', 'veliki');
	$content =  esc_html__('The page you are looking for might have been removed had its name changed or is temporarily unavailable.', 'veliki');
	$button =  esc_html__('Go to Home', 'veliki');
	$image = '';
endif;

if( isset( $veliki_opt['enable_lazyloader'] ) ):
    $is_lazyloader = $veliki_opt['enable_lazyloader'];
else:
    $is_lazyloader = true;
endif;

if( $is_lazyloader == true ):
    $lazy_class = 'smartify';
    $lazy_attr = 'sm-';
else:
    $lazy_class = '';
    $lazy_attr = '';
endif;
?>
	<div class="error-area">
		<div class="d-table">
			<div class="d-table-cell">
				<div class="container">
					<div class="error-content">
						<?php if( $image != '' ): ?>
							<img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url( $image ); ?> " alt="<?php echo esc_attr( $title ); ?>">
						<?php endif; ?>

						<?php if ( !isset( $veliki_opt['img-404'] ) ): ?>
							<img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php echo esc_url(get_template_directory_uri() .'/assets/img/404.png' ); ?>" alt="<?php echo esc_attr__( '404', 'veliki' ); ?>">
						<?php endif; ?>
					
						<h3><?php echo esc_html( $title ); ?></h3>
						<p><?php echo esc_html( $content ); ?></p>

						<?php if(  $button != '' ): ?>
							<a href="<?php echo esc_url( home_url( '/' ) ); ?>" class="btn btn-primary"><?php echo esc_html( $button ); ?> <i class="flaticon-next-1"></i></a>
						<?php endif; ?>
					</div>
				</div>
			</div>
		</div>
	</div>
<?php
get_footer();
