<?php
/**
 * The template for displaying all single posts
 * @package Veliki
 */

get_header();

// Blog Sidebar
if( isset( $veliki_opt['blog_sidebar']) ) {
    if( $veliki_opt['blog_sidebar'] == 'without_sidebar_center' ):
        $sidebar = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $veliki_opt['blog_sidebar'] == 'without_sidebar' ):
        $sidebar = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'article-sidebar' ) ):
            $sidebar = 'col-lg-8 col-md-12';
        else:
            $sidebar = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide = $veliki_opt['blog_sidebar'];
} else {
    if( is_active_sidebar( 'article-sidebar' ) ):
        $sidebar = 'col-lg-8 col-md-12';
        $sidebar_hide = 'with_sidebar';
    else:
        $sidebar = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide = 'without_sidebar';
    endif;
}
// After Hiding Banner add spacing
if( veliki_hide_page_banner() == 1 ){
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
}
// Page Banner Alignment Class Generate
if( veliki_page_banner_alignment() == 2 ){
    $alignment = 'text-center';
} elseif(veliki_page_banner_alignment() == 3) {
    $alignment = 'text-right';
} else {
	$alignment = 'text-left';
}

if ( function_exists('acf_add_options_page') ) {
	$bg = get_field( 'banner_background_image' );
} else {
	$bg = '';
}

if( isset( $veliki_opt['enable_lazyloader'] ) ):
    $is_lazyloader = $veliki_opt['enable_lazyloader'];
else:
    $is_lazyloader = true;
endif;

if( $is_lazyloader == true ):
    $lazy_class = 'smartify';
    $lazy_attr = 'sm-';
else:
    $lazy_class = '';
    $lazy_attr = '';
endif;

$veliki_blog_single_layout = !empty($veliki_opt['veliki_blog_single_layout']) ? $veliki_opt['veliki_blog_single_layout'] : 'container';
if ( !empty($_GET['veliki_blog_single_layout']) ) {
    $veliki_blog_single_layout = $_GET['veliki_blog_single_layout'];
}

if( isset($veliki_opt['page_title_tag']) ):
    $tag = $veliki_opt['page_title_tag'];
else:
    $tag = 'h2';
endif;

if( veliki_hide_page_banner() == 1 ) { }else { ?>
	<div class="page-title-area" style="background-image:url(<?php echo esc_url( $bg ); ?>);">
		<div class="container">
			<div class="page-title-content <?php echo esc_attr($alignment); ?>">
				<<?php echo esc_attr( $tag ); ?>><?php the_title(); ?></<?php echo esc_attr( $tag ); ?>>

				<?php
            	if(veliki_breadcumb() != 1){
					if ( function_exists('yoast_breadcrumb') ) {
                    	yoast_breadcrumb( '<p class="veliki-seo-breadcrumbs" id="breadcrumbs">','</p>' );
                	} else { ?>
					<ul>
						<li><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><?php esc_html_e('Home', 'veliki')?></a></li>
						<li><a href="<?php echo get_permalink( get_option( 'page_for_posts' ) ); ?>"><?php esc_html_e('Blog', 'veliki') ?></a></li>
						<li>
							<?php 
								$title = the_title('','',false);
								if (!empty($title)) { 
									the_title();
								}else{
									esc_html_e('No Title ', 'veliki');
								}
							?>
						</li>
					</ul><?php
					}
            	} ?>
			</div>
		</div>
	</div> <?php
} ?>

<!-- Start Blog Area -->
<div class="blog-details-area ptb-110 <?php echo esc_attr($page_spac); ?>"> 
	<div class="<?php echo esc_attr( $veliki_blog_single_layout ); ?>">
		<div class="row"> <?php
			while ( have_posts() ) : the_post(); ?>
				<div class="<?php echo esc_attr( $sidebar ); ?>">
					<div class="blog-details">
						<?php if(has_post_thumbnail()) { ?>
							<div class="article-img">
								<img class="<?php echo esc_attr($lazy_class); ?>" <?php echo esc_attr($lazy_attr); ?>src="<?php the_post_thumbnail_url('full') ?>" alt="<?php echo esc_attr__('blog image', 'veliki')?>">
							</div> <?php 
						} ?>

						<div class="blog-details-content">
							<?php if( isset( $veliki_opt['is_post_meta'] ) && $veliki_opt['is_post_meta'] == true ) { ?>
								<ul class="entry-meta">
									<li> <i class="far fa-user-circle"></i>
										<a href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ), get_the_author_meta( 'user_nicename' ) ) ) ?>">
											<?php the_author() ?>
										</a>
									</li>
									<li>
										<i class="far fa-calendar-alt"></i>
										<?php echo esc_html(get_the_date('F d, Y')) ?>
									</li>
									<li>
										<i class="far fa-comment-dots"></i> 
										<?php comments_number(); ?>
									</li>
								</ul>
							<?php } ?>
							
							<?php the_content(); 
							
							wp_link_pages( array(
								'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'veliki' ),
								'after'  => '</div>',
							) );
							?>

							<?php if ( get_the_tags() ) :  ?>
								<ul class="category">
									<li><span class="icon-book"><i class="fas fa-bookmark"></i></span></li>
									<?php $tags = get_the_tags();
									foreach ($tags as $tag ) :  ?>
										<li><a href="<?php echo esc_url(get_tag_link($tag->term_id)); ?>">
											<?php echo esc_html($tag->name) ?><span class="seperator"><?php echo esc_html(','); ?></span></a>
										</li> <?php
									endforeach; ?>
								</ul> 
							<?php endif; ?>
						</div>
					</div>
				
					<?php
					// If comments are open or we have at least one comment, load up the comment template.
					if ( comments_open() || get_comments_number() ) :
						comments_template();
					endif;
					?>
				</div> <?php 
			endwhile; // End of the loop.

			// Sidebar
			if( $sidebar_hide == 'with_sidebar' ): ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>

		</div>
	</div>
</div>
<!-- End Blog Area -->

<?php
get_footer();

