<?php global $veliki_opt;
/**
 * The Search template file
 * @package Veliki
 */

get_header(); ?>

<?php

// Blog Sidebar
if( isset( $veliki_opt['blog_sidebar']) ) {
    if( $veliki_opt['blog_sidebar'] == 'without_sidebar_center' ):
        $sidebar = 'col-lg-8 col-md-12 offset-lg-2';
    elseif( $veliki_opt['blog_sidebar'] == 'without_sidebar' ):
        $sidebar = 'col-lg-12 col-md-12';
    else:
        if( is_active_sidebar( 'article-sidebar' ) ):
            $sidebar = 'col-lg-8 col-md-12';
        else:
            $sidebar = 'col-lg-8 col-md-12 offset-lg-2';
        endif;
    endif;
    $sidebar_hide = $veliki_opt['blog_sidebar'];
} else {
    if( is_active_sidebar( 'article-sidebar' ) ):
        $sidebar = 'col-lg-8 col-md-12';
        $sidebar_hide = 'with_sidebar';
    else:
        $sidebar = 'col-lg-8 col-md-12 offset-lg-2';
        $sidebar_hide = 'without_sidebar';
    endif;
}

// Page Banner Alignment Class Generate
if( veliki_page_banner_alignment() == 2 ){
    $alignment = 'text-center';
} elseif(veliki_page_banner_alignment() == 3) {
    $alignment = 'text-right';
} else {
	$alignment = 'text-left';
}
$veliki_blog_layout = !empty($veliki_opt['veliki_blog_layout']) ? $veliki_opt['veliki_blog_layout'] : 'container';
if ( !empty($_GET['veliki_blog_layout']) ) {
    $veliki_blog_layout = $_GET['veliki_blog_layout'];
}
if( isset($veliki_opt['page_title_tag']) ):
    $tag = $veliki_opt['page_title_tag'];
else:
    $tag = 'h2';
endif;
// After Hiding Banner add spacing
if( veliki_hide_page_banner() == 1 ){
    $page_spac = 'mt-80';
} else {
    $page_spac = '';
}

if( isset( $veliki_opt['search_bg'] ) ) {
    $bg = $veliki_opt['search_bg']['url'];
} else {
    $bg = '';
} ?>

<div class="page-title-area" style="background-image:url(<?php echo esc_url( $bg ); ?>);">
    <div class="d-table">
        <div class="d-table-cell">
            <div class="container">
                <div class="page-title-content <?php echo esc_attr( $alignment ); ?>">
                    <<?php echo esc_attr( $tag ); ?>><?php printf( esc_html__( 'Search Results For : %s', 'veliki' ), '<span>' . get_search_query() . '</span>' ); ?></<?php echo esc_attr( $tag ); ?>>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Start Search Area -->
<div class="blog-area ptb-110 <?php echo esc_attr($page_spac); ?>">
    <div class="<?php echo esc_attr( $veliki_blog_layout ); ?>">
        <div class="row">
            <!-- Start Search Content -->
            <div class="<?php echo esc_attr( $sidebar ); ?>">
                <?php
                if ( have_posts() ) :
                    while ( have_posts() ) :
                        the_post();
                        get_template_part( 'template-parts/content',get_post_format());
                    endwhile;
                else :
                    get_template_part( 'template-parts/content', 'none' );
                endif;
                ?>
        
                <!-- Stat Pagination -->
                <div class="pagination-area">
                    <nav aria-label="navigation">
                    <?php echo paginate_links( array(
                        'format' => '?paged=%#%',
                        'prev_text' => '<i class="fa fa-angle-double-left"></i>',
                        'next_text' => '<i class="fa fa-angle-double-right"></i>',
                        )
                    ) ?>
                    </nav>
                </div>
            </div>
            <!-- End Search Content -->
            <?php if( $sidebar_hide == 'with_sidebar' ): ?>
                <?php get_sidebar(); ?>
            <?php endif; ?>
        </div>   
    </div>
</div>
<!-- End Search Area -->
<?php
get_footer();
