<?php
/**
 * Include the TGM_Plugin_Activation class.
 */

require_once dirname( __FILE__ ) . '/class-tgm-plugin-activation.php';
add_action( 'tgmpa_register', 'veliki_register_required_plugins' );

if ( ! function_exists( 'veliki_register_required_plugins' ) ) {
	function veliki_register_required_plugins() {

		$plugins = array(
			
			// Veliki Toolkit
			array(
				'name'               => esc_html__('Veliki Toolkit', 'veliki'),
				'slug'               => 'veliki-toolkit',
				'source'             => get_template_directory() . '/lib/plugins/veliki-toolkit.zip', 
				'required'           => true,
			),

			// Elemantor Page Builder
			array(
				'name'               => esc_html__('Elementor Page Builder', 'veliki'),
				'slug'               => 'elementor',
				'required'           => true,
			),

			// Advanced Custom Fields Pro
			array(
				'name'               => esc_html__('Advanced Custom Fields Pro', 'veliki'),
				'slug'               => 'advanced-custom-fields-pro',
				'source'             => get_template_directory() . '/lib/plugins/advanced-custom-fields-pro.zip', 
				'required'           => true,
			),

			// Veliki Plugins
			array(
				'name'      => esc_html__('Contact Form 7', 'veliki'),
				'slug'      => 'contact-form-7',
				'required'  => false,
			),
			array(
				'name'      => esc_html__('WooCommerce', 'veliki'),
				'slug'      => 'woocommerce',
				'required'  => false,
			),
			array(
				'name'		 => esc_html__( 'Unyson', 'veliki' ),
				'slug'		 => 'unyson',
				'source'     => get_template_directory() . '/lib/plugins/unyson.zip', 
				'required'	 => true,
			),
		);

		$config = array(
			'id'           => 'tgmpa',
			'default_path' => '',
			'menu'         => 'tgmpa-install-plugins',
			'parent_slug'  => 'themes.php',
			'capability'   => 'edit_theme_options',
			'has_notices'  => true, 
			'dismissable'  => true, 
			'dismiss_msg'  => '',   
			'is_automatic' => false, 
			'message'      => '',                      
		);
		tgmpa( $plugins, $config );
	}
}