<?php
/**
 * Register Theme Widget
 * @package Veliki
 */


// Theme Sidebar
function veliki_widgets_init() {

    // Blog Sidebar
	register_sidebar( array(
		'name'          => esc_html__( 'Blog Sidebar', 'veliki' ),
		'id'            => 'article-sidebar',
		'description'   => esc_html__( 'Add widgets here.', 'veliki' ),
		'before_widget' => '<div id="%1$s" class="widget %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h2 class="widget-title">',
		'after_title'   => '</h2>',
    ) );

    // Shop Sidebar
    register_sidebar( array( 
        'name'          => esc_html__( 'Shop Sidebar', 'veliki' ),
        'id'            => 'shop',
        'description'   => esc_html__( 'Add widgets here.', 'veliki' ),
        'before_widget' => '<div class="widget %2$s">',
        'after_widget'  => '</div>',
        'before_title'  => '<h3>',
        'after_title'   => '</h3>',
    ) );
    // Footer Sidebar
	global $veliki_opt;
	$footer_column = !empty($veliki_opt['footer_column']) ? $veliki_opt['footer_column'] : '3';
	register_sidebar( array( 
		'name'          => esc_html__( 'Footer Widgets', 'veliki' ),
		'id'            => 'footer_widgets',
		'description'   => esc_html__( 'Add widgets here.', 'veliki' ),
		'before_widget' => '<div class="single-footer-widget col-lg-'.$footer_column.' col-md-6  col-sm-6  %2$s">',
		'after_widget'  => '</div>',
		'before_title'  => '<h3>',
		'after_title'   => '</h3>',
	) );
}
add_action( 'widgets_init', 'veliki_widgets_init' );