<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package Veliki
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * @return array
 */
function veliki_body_classes( $classes ) {
	// Adds a class of hfeed to non-singular pages.
	if ( ! is_singular() ) {
		$classes[] = 'hfeed';
	}

	// Adds a class of no-sidebar when there is no sidebar present.
	if ( ! is_active_sidebar( 'sidebar-1' ) ) {
		$classes[] = 'no-sidebar';
	}

	return $classes;
}
add_filter( 'body_class', 'veliki_body_classes' );

/**
 * Add a pingback url auto-discovery header for single posts, pages, or attachments.
 */
function veliki_pingback_header() {
	if ( is_singular() && pings_open() ) {
		printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
	}
}
add_action( 'wp_head', 'veliki_pingback_header' );

/**
 * Veliki Preloader
*/

if ( ! function_exists( 'veliki_preloader' ) ) :
	function veliki_preloader() { 
		global $veliki_opt;

		if( isset( $veliki_opt['enable_preloader'] ) ):
			$is_preloader = $veliki_opt['enable_preloader'];
		else:
			$is_preloader = true;
		endif;

		//$is_preloader       = !empty($veliki_opt['enable_preloader']) ? $veliki_opt['enable_preloader'] : '1';
		
        $preloader_style    = !empty($veliki_opt['preloader_style']) ? $veliki_opt['preloader_style'] : 'circle-spin';

        if( $is_preloader == true ): 
            if ( defined( 'ELEMENTOR_VERSION' ) ) :
                if (\Elementor\Plugin::$instance->preview->is_preview_mode()) :
                    echo '';
                else:
                    if ( $preloader_style == 'text' ) :
                        if (!empty( $veliki_opt['loading_text'] ) ) : ?>
                            <div class="preloader">
								<p class="text-center"> <?php echo esc_html( $veliki_opt['loading_text'] ) ?> </p>
                            </div>
                        <?php endif;
                    elseif( $preloader_style == 'circle-spin' ) : ?>
						<div class="preloader">
							<div class="sk-folding-cube">
								<div class="sk-cube1 sk-cube"></div>
								<div class="sk-cube2 sk-cube"></div>
								<div class="sk-cube4 sk-cube"></div>
								<div class="sk-cube3 sk-cube"></div>
							</div>
						</div>
                    <?php else: ?>
                        <div class="preloader preloader-img">
                        </div>
                    <?php endif;
                endif;
            else:
                if ( $preloader_style == 'text' ) :
                    if (!empty( $veliki_opt['loading_text'] ) ) : ?>
                        <div class="preloader">
                            <p class="text-center"> <?php echo esc_html( $veliki_opt['loading_text'] ) ?> </p>
                        </div>
                    <?php endif;
                elseif( $preloader_style == 'circle-spin' ) :
                    ?>
                    <div class="preloader">
						<div class="sk-folding-cube">
							<div class="sk-cube1 sk-cube"></div>
							<div class="sk-cube2 sk-cube"></div>
							<div class="sk-cube4 sk-cube"></div>
							<div class="sk-cube3 sk-cube"></div>
						</div>
					</div>
                <?php else : ?>
                    <div class="preloader preloader-img">
                    </div>
                    <?php 
                endif;
            endif;
        endif;
	}
endif;

/**
  * Veliki Nav
*/
if ( ! function_exists( 'veliki_nav_area' ) ) :
	function veliki_nav_area() { 
		global $veliki_opt;

		// Button text and link
		if( isset($veliki_opt['address']) ):
			$address              = $veliki_opt['address'];
			$address_info         = $veliki_opt['address_info'];
			$call_number_text     = $veliki_opt['call_number_text'];
			$call_number          = $veliki_opt['call_number'];
			$email_text           = $veliki_opt['email_text'];
			$email                = $veliki_opt['email'];
			$enable_search        = $veliki_opt['enable_search'];
			$enable_cart          = $veliki_opt['enable_cart_btn'];
			$enable_header_btn    = $veliki_opt['enable_header_btn'];
			$header_btn_text	  = $veliki_opt['header_btn_text'];
		else:
			$address               = '';
			$address_info          = '';
			$call_number_text      = '';
			$call_number           = '';
			$email_text            = '';
			$email                 = '';
			$enable_search         = 'false';
			$enable_cart           = 'false';
			$enable_header_btn     = 'false';
			$header_btn_text       = '';

		endif;

		$btn_link = !empty($veliki_opt['button_type']) ? $veliki_opt['button_type'] : 'external_link';
		$button_page_link = !empty($veliki_opt['button_page_link']) ? $veliki_opt['button_page_link'] : '';
								
		// Left Button Link Page
		if( $btn_link == 'link_to_page') {
			// Page link
			$btn_link 		= get_page_link( $button_page_link );
		} else {
			$btn_link	    = $veliki_opt['button_ex_link'];
		}

		// White Logo
		if(isset($veliki_opt['white_logo']['url']) && $veliki_opt['white_logo']['url'] !='' ) {
			$white_logo = $veliki_opt['white_logo']['url'];
		} else {
			$white_logo = "null";
		}

		// After Hiding Banner add spacing
		if( veliki_hide_page_banner_acf() == 'yes' || veliki_hide_page_banner() == 1 ){
			$nav_class = "nav-color";
		} else {
			$nav_class = "";
		} 

		$enable_top_header 	= isset( $veliki_opt['hide_top_header'] ) ? $veliki_opt['hide_top_header'] : false;

		// Choose Navbar Style
		if (class_exists('ACF')) {
			if( get_field('choose_navigation_style') == 2 ) {
				$nav_style = 2;
			} elseif( get_field('choose_navigation_style', get_option('page_for_posts') ) == 2 ) {
				$nav_style = 2;
			}else {
				$nav_style = 1;
			}

			if( get_field('container_layout') == 2 ) {
				$container_cls = "container-fluid";
			} elseif( get_field('container_layout', get_option('page_for_posts') ) == 2 ) {
				$container_cls = "container-fluid";
			} else {
				$container_cls = "container";
			}

			$enable_top_header	= get_field( 'top_header' );

			if( is_home() ) {
				$enable_top_header	= get_field( 'top_header' , get_option('page_for_posts') );
			}
		} else {
			$container_cls = "container";
			$nav_style = 1;
		} 
	
		// WP Nav Class
		$hide_wp_nav = "hide-wp-nav";

		if ( !is_404()){ ?>	
			<?php if($nav_style == 2): ?>
				<div class="navbar-area navbar-area-with-main-color <?php if ( is_user_logged_in() ) {echo esc_attr($hide_wp_nav);} ?>">
					<div class="evolta-responsive-nav <?php if ( is_user_logged_in() ) {echo esc_attr($hide_wp_nav);} ?>">
						<div class="container">
							<div class="evolta-responsive-menu">
								<div class="logo">
									<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
										<?php
										// Black Logo
										if ( $white_logo != 'null' ) { ?>
											<img src="<?php echo esc_url($white_logo); ?>" alt="<?php bloginfo( 'name' ); ?>"><?php
										} else{ ?>
											<h2 class="main-title"><?php bloginfo( 'name' ); ?></h2>
										<?php }  ?>
									</a>
								</div>
							</div>
						</div>
					</div>

					<div class="evolta-nav">
						<div class="<?php echo esc_attr($container_cls); ?>">
							<nav class="navbar navbar-expand-md navbar-light">
								<a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
									<?php
									// Logo
									if ( $white_logo != 'null' ) { ?>
										<img src="<?php echo esc_url( $white_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>"><?php
									} else { ?>
										<h2 class="main-title"><?php bloginfo( 'name' ); ?></h2><?php 
									}  ?>
								</a>

								<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
									<?php if(has_nav_menu('header')){
										wp_nav_menu( array(
											'theme_location'  => 'header',
											'depth'           => 3,
											'container'       => 'null',
											'menu_class'      => 'navbar-nav main-menu ml-auto',
											'fallback_cb'     => 'Veliki_Bootstrap_Navwalker::fallback',
											'walker'          => new Veliki_Bootstrap_Navwalker()
										) );
									} ?>

									<div class="others-options"> <?php
										if( $enable_search == true || $enable_cart == true) { ?>

											<?php if ( class_exists( 'WooCommerce' ) ) { ?>
												<a class="cart-btn" href="<?php echo esc_url(wc_get_cart_url()) ?>">
													<i class='flaticon-shopping-basket'></i>
													<span class="mini-cart-count"></span>
												</a>
											<?php } ?>

											<div class="option-item"><i class="search-btn flaticon-search"></i>
												<i class="close-btn fas fa-times"></i>
												
												<div class="search-overlay search-popup">
													<div class='search-box'>
														<form role="search" method="get" id="searchform" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
	
															<input type="text" class="search-input" value="<?php echo get_search_query(); ?>" name="s" id="s" placeholder="<?php esc_attr_e('Search','veliki'); ?>" required />
	
															<button type="submit" id="searchsubmit" class="search-button"><i class="fas fa-search"></i></button>
														</form>
													</div>
												</div>
											</div>
											<?php 
										} 
										if( $enable_header_btn == true && $header_btn_text != '' ) { ?>
											<a href="<?php echo esc_url( $btn_link ); ?>" class="btn btn-primary"><?php echo esc_html( $header_btn_text ); ?></a> <?php 
										} ?>
	
									</div>
								</div>
							</nav>
						</div>
					</div>
				</div>
			<?php else: ?>
				<header class="header-area <?php echo esc_attr( $nav_class ); ?> <?php if ( is_user_logged_in() ) {echo esc_attr($hide_wp_nav);} ?>">

					<!-- Start Top Header -->
					<?php if( $enable_top_header ){ 
						if( $address != '' || $address_info != '' || $call_number_text != '' || $call_number != '' || $email_text != '' || $email != '' ) { ?>
							<div class="top-header">
								<div class="<?php echo esc_attr($container_cls); ?>">
									<div class="row align-items-center">
										<div class="col-lg-6 col-md-6">
											<p><span><?php echo esc_html( $address ); ?></span> <i class="flaticon-placeholder"></i> <span class="top-add"><?php echo esc_html( $address_info ); ?></span></p>
										</div>
										
										<div class="col-lg-6 col-md-6">
											<ul>
												<li><span><?php echo esc_html( $call_number_text ); ?></span> <i class="flaticon-phone-call"></i> <a href="<?php echo esc_attr__("tel:", "veliki"); ?><?php echo wp_kses_post(str_replace(' ', '', $call_number ), "veliki") ?>"><?php echo esc_html( $call_number ); ?></a></li>
												<li><span><?php echo esc_html( $email_text ); ?></span> <i class="flaticon-message-closed-envelope"></i> <a href="<?php echo esc_attr__("mailto:","veliki") ?><?php echo wp_kses_post($email) ?>"><?php echo esc_html( $email ); ?></a></li>
											</ul>
										</div>
									</div>
								</div>
							</div>
						<?php }
					} ?>

					<!-- Start Navbar Area -->
					<div class="navbar-area">
						<div class="evolta-responsive-nav <?php if ( is_user_logged_in() ) {echo esc_attr($hide_wp_nav);} ?>">
							<div class="container">
								<div class="evolta-responsive-menu">
									<div class="logo">
										<a href="<?php echo esc_url( home_url( '/' ) ); ?>">
											<?php
											// Black Logo
											if ( $white_logo != 'null' ) { ?>
												<img src="<?php echo esc_url($white_logo); ?>" alt="<?php bloginfo( 'name' ); ?>"><?php
											} else{ ?>
												<h2 class="main-title"><?php bloginfo( 'name' ); ?></h2>
											<?php }  ?>
										</a>
									</div>
								</div>
							</div>
						</div>

						<div class="evolta-nav">
							<div class="<?php echo esc_attr($container_cls); ?>">
								<nav class="navbar navbar-expand-md navbar-light">
									<a class="navbar-brand" href="<?php echo esc_url( home_url( '/' ) ); ?>">
										<?php
										// Logo
										if ( $white_logo != 'null' ) { ?>
											<img src="<?php echo esc_url( $white_logo ); ?>" alt="<?php bloginfo( 'name' ); ?>"><?php
										} else { ?>
											<h2 class="main-title"><?php bloginfo( 'name' ); ?></h2><?php 
										}  ?>
									</a>

									<div class="collapse navbar-collapse mean-menu" id="navbarSupportedContent">
										<?php if(has_nav_menu('header')){
											wp_nav_menu( array(
												'theme_location'  => 'header',
												'depth'           => 3,
												'container'       => 'null',
												'menu_class'      => 'navbar-nav main-menu ml-auto',
												'fallback_cb'     => 'Veliki_Bootstrap_Navwalker::fallback',
												'walker'          => new Veliki_Bootstrap_Navwalker()
											) );
										} ?>

										<div class="others-options"> <?php
											if( $enable_search == true || $enable_cart == true) { ?>

												<?php if ( class_exists( 'WooCommerce' ) ) { ?>
													<a class="cart-btn" href="<?php echo esc_url(wc_get_cart_url()) ?>">
														<i class='flaticon-shopping-basket'></i>
														<span class="mini-cart-count"></span>
													</a>
												<?php } ?>

												<div class="option-item"><i class="search-btn flaticon-search"></i>
													<i class="close-btn fas fa-times"></i>
													
													<div class="search-overlay search-popup">
														<div class='search-box'>
															<form role="search" method="get" id="searchform" class="search-form" action="<?php echo esc_url( home_url( '/' ) ); ?>">
		
																<input type="text" class="search-input" value="<?php echo get_search_query(); ?>" name="s" id="s" placeholder="<?php esc_attr_e('Search','veliki'); ?>" required />
		
																<button type="submit" id="searchsubmit" class="search-button"><i class="fas fa-search"></i></button>
															</form>
														</div>
													</div>
												</div>
												<?php 
											} 
											if( $enable_header_btn == true && $header_btn_text != '' ) { ?>
												<a href="<?php echo esc_url( $btn_link ); ?>" class="btn btn-primary"><?php echo esc_html( $header_btn_text ); ?></a> <?php 
											} ?>
		
										</div>
									</div>
								</nav>
							</div>
						</div>
					</div>

				</header>
			<?php endif; ?>
			<?php 
		} 
	}
endif;

/**
 * Veliki RTL
 */
if( ! function_exists( 'veliki_rtl' ) ):
	function veliki_rtl() {
		global $veliki_opt;

		if(	isset( $veliki_opt['veliki_enable_rtl'])  ):
			$veliki_rtl_opt = $veliki_opt['veliki_enable_rtl'];
		else:
			$veliki_rtl_opt = 'disable';
		endif;

		if ( isset( $_GET['rtl'] ) ) {
			$veliki_rtl_opt = $_GET['rtl'];
		}

		if( $veliki_rtl_opt == 'enable' ):
			$veliki_rtl = true;
		else:
			$veliki_rtl = false;
		endif;
		
		return $veliki_rtl;
	}
endif;